/*
 * Decompiled with CFR 0.152.
 */
package com.effektif.adapter;

import com.effektif.adapter.ActivityAdapter;
import com.effektif.adapter.DataSourceAdapter;
import com.effektif.adapter.DefaultAdapterConfiguration;
import com.effektif.adapter.DescriptorsResource;
import com.effektif.adapter.ExecuteResource;
import com.effektif.adapter.FindItemsResource;
import com.effektif.adapter.helpers.DefaultExceptionMapper;
import com.effektif.adapter.helpers.RequestLogger;
import com.effektif.server.EffektifJsonProvider;
import com.effektif.workflow.impl.json.JsonStreamMapper;
import java.net.URI;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterServer {
    public static final Logger log = LoggerFactory.getLogger(AdapterServer.class);
    protected Integer port;
    protected ResourceConfig config;
    protected Server server;
    protected JsonStreamMapper jsonMapper;
    protected DescriptorsResource descriptorsResource;
    protected ExecuteResource executeResource;
    protected FindItemsResource findItemsResource;

    public AdapterServer() {
        DefaultAdapterConfiguration configuration = new DefaultAdapterConfiguration();
        this.jsonMapper = (JsonStreamMapper)configuration.get(JsonStreamMapper.class);
        this.jsonMapper.pretty();
        this.descriptorsResource = new DescriptorsResource();
        this.executeResource = new ExecuteResource(configuration);
        this.findItemsResource = new FindItemsResource();
        this.config = new ResourceConfig();
        this.config.registerInstances(new Object[]{new EffektifJsonProvider(this.jsonMapper), new RequestLogger(), new DefaultExceptionMapper(), this.descriptorsResource, this.executeResource, this.findItemsResource});
    }

    public AdapterServer port(Integer port) {
        this.port = port;
        return this;
    }

    public AdapterServer registerDataSourceAdapter(DataSourceAdapter dataSourceAdapter) {
        this.descriptorsResource.addDataSourceDescriptor(dataSourceAdapter.getDescriptor());
        this.findItemsResource.addDataSourceAdapter(dataSourceAdapter);
        return this;
    }

    public AdapterServer registerActivityAdapter(ActivityAdapter activityAdapter) {
        this.descriptorsResource.addActivityDescriptor(activityAdapter.getDescriptor());
        this.executeResource.addActivityAdapter(activityAdapter);
        return this;
    }

    public void startup() {
        try {
            URI baseUri = new URI("http://localhost" + (this.port != null ? ":" + this.port : "") + "/");
            this.server = this.createServer(baseUri);
            this.server.start();
            log.info("Workflow adapter started.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected Server createServer(URI baseUri) {
        return JettyHttpContainerFactory.createServer((URI)baseUri, (ResourceConfig)this.config);
    }

    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public ResourceConfig getResourceConfig() {
        return this.config;
    }
}

