/*
 * Decompiled with CFR 0.152.
 */
package com.effektif.adapter;

import com.effektif.adapter.ActivityAdapter;
import com.effektif.adapter.ActivityContext;
import com.effektif.adapter.service.ExecuteRequest;
import com.effektif.adapter.service.ExecuteResponse;
import com.effektif.workflow.api.Configuration;
import com.effektif.workflow.impl.exceptions.BadRequestException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/execute")
public class ExecuteResource {
    private static final Logger log = LoggerFactory.getLogger(ExecuteResource.class);
    protected Configuration configuration;
    protected Map<String, ActivityAdapter> activityAdapters = new HashMap<String, ActivityAdapter>();

    public ExecuteResource(Configuration configuration) {
        this.configuration = configuration;
    }

    @POST
    @Produces(value={"application/json"})
    public ExecuteResponse execute(ExecuteRequest executeRequest) {
        String activityKey = executeRequest.getActivityKey();
        ActivityAdapter activityAdapter = this.activityAdapters.get(activityKey);
        if (activityAdapter == null) {
            throw new BadRequestException("No activity found for key " + activityKey);
        }
        ActivityContext activityContext = new ActivityContext(this.configuration, executeRequest);
        activityAdapter.execute(activityContext);
        return activityContext.getExecuteResponse();
    }

    public void addActivityAdapter(ActivityAdapter activityAdapter) {
        String activityKey = activityAdapter.getDescriptor().getKey();
        log.debug("Adding activity '" + activityKey + "' --> " + activityAdapter);
        this.activityAdapters.put(activityKey, activityAdapter);
    }
}

