/*
 * Decompiled with CFR 0.152.
 */
package com.effektif.adapter;

import com.effektif.adapter.DataSourceAdapter;
import com.effektif.adapter.service.FindItemsRequest;
import com.effektif.workflow.api.datasource.ItemReference;
import com.effektif.workflow.impl.exceptions.BadRequestException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/items")
public class FindItemsResource {
    private static final Logger log = LoggerFactory.getLogger(FindItemsResource.class);
    protected Map<String, DataSourceAdapter> dataSourceAdapters = new HashMap<String, DataSourceAdapter>();

    @POST
    @Produces(value={"application/json"})
    public List<ItemReference> findItems(FindItemsRequest request) {
        String dataSourceKey = request.getDataSourceKey();
        DataSourceAdapter dataSourceAdapter = this.dataSourceAdapters.get(dataSourceKey);
        if (dataSourceAdapter == null) {
            throw new BadRequestException("No data source found for key " + dataSourceKey);
        }
        return dataSourceAdapter.findItems(request.getItemQuery());
    }

    public void addDataSourceAdapter(DataSourceAdapter dataSourceAdapter) {
        String dataSourceKey = dataSourceAdapter.getDescriptor().getDataSourceKey();
        log.debug("Adding data source '" + dataSourceKey + "' --> " + dataSourceAdapter);
        this.dataSourceAdapters.put(dataSourceKey, dataSourceAdapter);
    }
}

