/*
 * Decompiled with CFR 0.152.
 */
package com.effektif.adapter.helpers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.internal.util.collection.StringIgnoreCaseKeyComparator;
import org.glassfish.jersey.message.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger
implements ContainerRequestFilter,
ContainerResponseFilter,
WriterInterceptor {
    public static final Logger log = LoggerFactory.getLogger((String)"HTTP");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String REQUEST_PREFIX = ">>> ";
    private static final String RESPONSE_PREFIX = "<<< ";
    private static final String ENTITY_LOGGER_PROPERTY = LoggingFilter.class.getName() + ".entityLogger";
    private static final Comparator<Map.Entry<String, List<String>>> COMPARATOR = new Comparator<Map.Entry<String, List<String>>>(){

        @Override
        public int compare(Map.Entry<String, List<String>> o1, Map.Entry<String, List<String>> o2) {
            return StringIgnoreCaseKeyComparator.SINGLETON.compare(o1.getKey(), o2.getKey());
        }
    };
    private static final int DEFAULT_MAX_ENTITY_SIZE = 102400;
    protected boolean logEntity = true;
    protected boolean logEntityJsonPretty = true;
    protected boolean logHeaders = false;
    private final AtomicLong _id = new AtomicLong(0L);
    private final int maxEntitySize = 102400;

    public void filter(ContainerRequestContext context) throws IOException {
        long id = this._id.incrementAndGet();
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("\n\n").append(REQUEST_PREFIX).append(" ").append(context.getMethod()).append(" /").append(context.getUriInfo().getPath()).append("\n");
        if (this.logHeaders) {
            this.logHeaders(logMsg, id, REQUEST_PREFIX, (MultivaluedMap<String, String>)context.getHeaders());
        }
        if (this.logEntity && context.hasEntity()) {
            context.setEntityStream(this.logInboundEntity(logMsg, context.getEntityStream(), MessageUtils.getCharset((MediaType)context.getMediaType())));
        }
        if (log.isDebugEnabled()) {
            log.debug(logMsg.toString());
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        long id = this._id.incrementAndGet();
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("\n<<< ").append(responseContext.getStatus()).append("\n");
        if (this.logHeaders) {
            this.logHeaders(logMsg, id, RESPONSE_PREFIX, (MultivaluedMap<String, String>)responseContext.getStringHeaders());
        }
        if (this.logEntity && responseContext.hasEntity()) {
            LoggingStream stream = new LoggingStream(logMsg, responseContext.getEntityStream());
            responseContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else if (log.isDebugEnabled()) {
            log.debug(logMsg.toString());
        }
    }

    private InputStream logInboundEntity(StringBuilder b, InputStream stream, Charset charset) throws IOException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(102401);
        byte[] entity = new byte[102401];
        int entitySize = stream.read(entity);
        b.append(REQUEST_PREFIX);
        String entityString = new String(entity, 0, Math.min(entitySize, 102400), charset);
        if (this.logEntityJsonPretty && entitySize <= 102400) {
            entityString = this.getJsonPrettyString(entityString);
        }
        b.append(entityString);
        if (entitySize > 102400) {
            b.append("...more...");
        }
        stream.reset();
        return stream;
    }

    protected String getJsonPrettyString(String entityString) {
        try {
            Object json = OBJECT_MAPPER.readValue(entityString, Object.class);
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)writerInterceptorContext.getProperty(ENTITY_LOGGER_PROPERTY);
        writerInterceptorContext.proceed();
        if (stream != null && log.isDebugEnabled()) {
            log.debug(stream.getStringBuilder(MessageUtils.getCharset((MediaType)writerInterceptorContext.getMediaType())).toString());
        }
    }

    private void logHeaders(StringBuilder logMsg, long id, String prefix, MultivaluedMap<String, String> headers) {
        for (Map.Entry<String, List<String>> headerEntry : this.getSortedHeaders(headers.entrySet())) {
            List<String> val = headerEntry.getValue();
            String header = headerEntry.getKey();
            if (val.size() == 1) {
                logMsg.append(prefix).append(header).append(": ").append((Object)val.get(0)).append("\n");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            boolean add = false;
            for (String s : val) {
                if (add) {
                    sb.append(',');
                }
                add = true;
                sb.append((Object)s);
            }
            logMsg.append(prefix).append(header).append(": ").append(sb.toString()).append("\n");
        }
    }

    private Set<Map.Entry<String, List<String>>> getSortedHeaders(Set<Map.Entry<String, List<String>>> headers) {
        TreeSet<Map.Entry<String, List<String>>> sortedHeaders = new TreeSet<Map.Entry<String, List<String>>>(COMPARATOR);
        sortedHeaders.addAll(headers);
        return sortedHeaders;
    }

    private class LoggingStream
    extends OutputStream {
        private final StringBuilder logMsg;
        private final OutputStream inner;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        LoggingStream(StringBuilder logMsg, OutputStream inner) {
            this.logMsg = logMsg;
            this.inner = inner;
        }

        StringBuilder getStringBuilder(Charset charset) {
            byte[] entity = this.baos.toByteArray();
            String entityString = new String(entity, 0, Math.min(entity.length, 102400), charset);
            if (RequestLogger.this.logEntityJsonPretty && entity.length <= 102400) {
                entityString = RequestLogger.this.getJsonPrettyString(entityString);
            }
            this.logMsg.append(entityString);
            if (entity.length > 102400) {
                this.logMsg.append("...more...");
            }
            return this.logMsg;
        }

        @Override
        public void write(int i) throws IOException {
            if (this.baos.size() <= 102400) {
                this.baos.write(i);
            }
            this.inner.write(i);
        }
    }
}

