/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core;

import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.DefaultNoticeRequest;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.NoticeRequest;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.RefundResult;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.spring.boot.core.PayServiceManager;
import com.egzosn.pay.spring.boot.core.bean.MerchantPayOrder;
import com.egzosn.pay.spring.boot.core.bean.MerchantQueryOrder;
import com.egzosn.pay.spring.boot.core.merchant.MerchantDetailsService;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;

public class MerchantPayServiceManager
implements PayServiceManager {
    @Autowired
    private MerchantDetailsService<PaymentPlatformMerchantDetails> detailsService;

    @Override
    public boolean verify(String detailsId, Map<String, Object> params) {
        return this.verify(detailsId, new NoticeParams(params));
    }

    @Override
    public boolean verify(String detailsId, NoticeParams params) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        return details.getPayService().verify(params);
    }

    @Override
    @Deprecated
    public Map<String, Object> getParameter2Map(String detailsId, Map<String, String[]> parameterMap, InputStream is) {
        return this.getNoticeParams(detailsId, (NoticeRequest)new DefaultNoticeRequest(parameterMap, is)).getBody();
    }

    @Override
    public NoticeParams getNoticeParams(String detailsId, NoticeRequest request) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        return details.getPayService().getNoticeParams(request);
    }

    @Override
    public String toPay(MerchantPayOrder payOrder) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(payOrder.getDetailsId());
        payOrder.setTransactionType(details.getPaymentPlatform().getTransactionType(payOrder.getWayTrade()));
        Object payService = details.getPayService();
        Map orderInfo = payService.orderInfo((PayOrder)payOrder);
        return payService.buildRequest(orderInfo, MethodType.POST);
    }

    @Override
    public Map<String, Object> app(MerchantPayOrder payOrder) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(payOrder.getDetailsId());
        payOrder.setTransactionType(details.getPaymentPlatform().getTransactionType(payOrder.getWayTrade()));
        Object payService = details.getPayService();
        return payService.app((PayOrder)payOrder);
    }

    @Override
    public Map<String, Object> getOrderInfo(MerchantPayOrder payOrder) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(payOrder.getDetailsId());
        payOrder.setTransactionType(details.getPaymentPlatform().getTransactionType(payOrder.getWayTrade()));
        Object payService = details.getPayService();
        return payService.orderInfo((PayOrder)payOrder);
    }

    @Override
    public Map<String, Object> microPay(MerchantPayOrder payOrder) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(payOrder.getDetailsId());
        payOrder.setTransactionType(details.getPaymentPlatform().getTransactionType(payOrder.getWayTrade()));
        return details.getPayService().microPay((PayOrder)payOrder);
    }

    @Override
    public byte[] toQrPay(MerchantPayOrder payOrder) throws IOException {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(payOrder.getDetailsId());
        payOrder.setTransactionType(details.getPaymentPlatform().getTransactionType(payOrder.getWayTrade()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)details.getPayService().genQrPay((PayOrder)payOrder), "JPEG", baos);
        return baos.toByteArray();
    }

    @Override
    public String getQrPay(MerchantPayOrder payOrder) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(payOrder.getDetailsId());
        payOrder.setTransactionType(details.getPaymentPlatform().getTransactionType(payOrder.getWayTrade()));
        return details.getPayService().getQrPay((PayOrder)payOrder);
    }

    @Override
    @Deprecated
    public String payBack(String detailsId, Map<String, String[]> parameterMap, InputStream is) throws IOException {
        return this.payBack(detailsId, (NoticeRequest)new DefaultNoticeRequest(parameterMap, is));
    }

    @Override
    public String payBack(String detailsId, NoticeRequest request) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        Object payService = details.getPayService();
        return payService.payBack(request).toMessage();
    }

    @Override
    public Map<String, Object> query(MerchantQueryOrder order) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(order.getDetailsId());
        return details.getPayService().query((AssistOrder)order);
    }

    @Override
    public Map<String, Object> close(MerchantQueryOrder order) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(order.getDetailsId());
        return details.getPayService().close((AssistOrder)order);
    }

    @Override
    public RefundResult refund(String detailsId, RefundOrder order) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        return details.getPayService().refund(order);
    }

    @Override
    public Map<String, Object> refundQuery(String detailsId, RefundOrder order) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        return details.getPayService().refundquery(order);
    }

    @Override
    public Map<String, Object> downloadBill(MerchantQueryOrder order) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(order.getDetailsId());
        return details.getPayService().downloadBill(order.getBillDate(), order.getBillType());
    }

    @Override
    public Map<String, Object> transfer(String detailsId, TransferOrder order) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        return details.getPayService().transfer(order);
    }

    @Override
    public Map<String, Object> transferQuery(String detailsId, String outNo, String tradeNo) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        return details.getPayService().transferQuery(outNo, tradeNo);
    }

    @Override
    public PayMessage createMessage(String detailsId, Map<String, Object> message) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        return details.getPayService().createMessage(message);
    }

    @Override
    public <T extends PayService> T cast(String detailsId, Class<T> payServiceClass) {
        PaymentPlatformMerchantDetails details = this.detailsService.loadMerchantByMerchantId(detailsId);
        return (T)details.getPayService();
    }
}

