/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.merchant.bean;

import com.egzosn.pay.ali.api.AliPayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.PayConfigurerAdapter;
import com.egzosn.pay.spring.boot.core.builders.InMemoryMerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformServiceAdapter;
import com.egzosn.pay.spring.boot.core.provider.merchant.platform.PaymentPlatforms;

public class AliMerchantDetails
extends AliPayConfigStorage
implements PaymentPlatformMerchantDetails,
PaymentPlatformServiceAdapter,
PayConfigurerAdapter<InMemoryMerchantDetailsServiceBuilder> {
    private String detailsId;
    private volatile PayService payService;
    private PaymentPlatform platform;
    private InMemoryMerchantDetailsServiceBuilder builder;
    private HttpConfigStorage httpConfigStorage;

    @Override
    public InMemoryMerchantDetailsServiceBuilder and() {
        this.initService();
        return this.getBuilder();
    }

    @Override
    public InMemoryMerchantDetailsServiceBuilder getBuilder() {
        return this.builder;
    }

    public AliMerchantDetails(InMemoryMerchantDetailsServiceBuilder builder) {
        this();
        this.builder = builder;
    }

    public AliMerchantDetails() {
        String platformName = "aliPay";
        this.setPayType(platformName);
        this.platform = PaymentPlatforms.getPaymentPlatform(platformName);
    }

    @Override
    public PaymentPlatform getPaymentPlatform() {
        return this.platform;
    }

    @Override
    public PaymentPlatformServiceAdapter initService() {
        if (null == this.payService) {
            this.payService = this.platform.getPayService(this, this.getHttpConfigStorage());
        }
        return this;
    }

    public PayService getPayService() {
        return this.payService;
    }

    @Override
    public HttpConfigStorage getHttpConfigStorage() {
        return this.httpConfigStorage;
    }

    public AliMerchantDetails httpConfigStorage(HttpConfigStorage httpConfigStorage) {
        this.httpConfigStorage = httpConfigStorage;
        return this;
    }

    public void setDetailsId(String detailsId) {
        this.detailsId = detailsId;
    }

    @Override
    public String getDetailsId() {
        return this.detailsId;
    }

    public AliMerchantDetails detailsId(String detailsId) {
        this.detailsId = detailsId;
        return this;
    }

    public AliMerchantDetails notifyUrl(String notifyUrl) {
        this.setNotifyUrl(notifyUrl);
        return this;
    }

    public AliMerchantDetails returnUrl(String returnUrl) {
        this.setReturnUrl(returnUrl);
        return this;
    }

    public AliMerchantDetails signType(String signType) {
        this.setSignType(signType);
        return this;
    }

    public AliMerchantDetails inputCharset(String inputCharset) {
        this.setInputCharset(inputCharset);
        return this;
    }

    public AliMerchantDetails test(boolean test) {
        this.setTest(test);
        return this;
    }

    public AliMerchantDetails pid(String pid) {
        this.setPid(pid);
        return this;
    }

    public AliMerchantDetails appid(String appid) {
        this.setAppid(appid);
        return this;
    }

    public AliMerchantDetails keyPrivate(String keyPrivate) {
        this.setKeyPrivate(keyPrivate);
        return this;
    }

    public AliMerchantDetails keyPublic(String keyPublic) {
        this.setKeyPublic(keyPublic);
        return this;
    }

    public AliMerchantDetails seller(String seller) {
        this.setSeller(seller);
        return this;
    }
}

