/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.merchant.bean;

import com.egzosn.pay.common.api.BasePayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.CertStoreType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.PayConfigurerAdapter;
import com.egzosn.pay.spring.boot.core.builders.MerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformServiceAdapter;
import com.egzosn.pay.spring.boot.core.provider.merchant.platform.PaymentPlatforms;
import java.io.IOException;
import java.io.InputStream;

public class CommonPaymentPlatformMerchantDetails
extends BasePayConfigStorage
implements PaymentPlatformMerchantDetails,
PaymentPlatformServiceAdapter,
PayConfigurerAdapter<MerchantDetailsServiceBuilder> {
    private String detailsId;
    private String appId;
    private String mchId;
    private String seller;
    private String subAppId;
    private String subMchId;
    private Object keystore;
    private Object keyPublicCert;
    private Object keyCert;
    private String keyPrivateCertPwd;
    private CertStoreType certStoreType;
    private volatile PayService payService;
    private volatile PaymentPlatform platform;
    private MerchantDetailsServiceBuilder builder;
    private HttpConfigStorage httpConfigStorage;

    @Override
    public MerchantDetailsServiceBuilder and() {
        return this.getBuilder();
    }

    @Override
    public MerchantDetailsServiceBuilder getBuilder() {
        return this.builder;
    }

    public CommonPaymentPlatformMerchantDetails(MerchantDetailsServiceBuilder builder) {
        this();
        this.builder = builder;
    }

    public CommonPaymentPlatformMerchantDetails() {
    }

    @Override
    public PaymentPlatform getPaymentPlatform() {
        return this.platform;
    }

    @Override
    public PaymentPlatformServiceAdapter initService() {
        this.platform = PaymentPlatforms.getPaymentPlatform(this.getPayType());
        if (null == this.payService) {
            this.payService = this.platform.getPayService(this, this.getHttpConfigStorage());
        }
        return this;
    }

    public PayService getPayService() {
        return this.payService;
    }

    @Override
    public HttpConfigStorage getHttpConfigStorage() {
        return this.httpConfigStorage;
    }

    public void setHttpConfigStorage(HttpConfigStorage httpConfigStorage) {
        this.httpConfigStorage = httpConfigStorage;
    }

    public void setDetailsId(String detailsId) {
        this.detailsId = detailsId;
    }

    @Override
    public String getDetailsId() {
        return this.detailsId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    @Deprecated
    public String getAppid() {
        return this.appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPid() {
        return this.mchId;
    }

    public String getSeller() {
        return this.seller;
    }

    public void setSeller(String seller) {
        this.seller = seller;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }

    public void setKeystore(String keystore) {
        super.setKeyPrivate(keystore);
        this.keystore = keystore;
    }

    public void setKeystore(InputStream keystore) {
        this.keystore = keystore;
    }

    public InputStream getKeystoreInputStream() throws IOException {
        return this.certStoreType.getInputStream(this.keystore);
    }

    public Object getKeystore() {
        return this.keystore;
    }

    public String getKeystorePwd() {
        return this.getKeyPrivateCertPwd();
    }

    public void setKeystorePwd(String keystorePwd) {
        this.setKeyPrivateCertPwd(keystorePwd);
    }

    public String getKeyPrivateCertPwd() {
        return this.keyPrivateCertPwd;
    }

    public void setKeyPrivateCertPwd(String keyPrivateCertPwd) {
        this.keyPrivateCertPwd = keyPrivateCertPwd;
    }

    public String getKeyPublicCert() {
        return (String)this.keyPublicCert;
    }

    public void setKeyPublicCert(String keyPublicCert) {
        this.setKeyPublic(keyPublicCert);
        this.keyPublicCert = keyPublicCert;
    }

    public void setKeyPublicCert(InputStream keyPublicCert) {
        this.keyPublicCert = keyPublicCert;
    }

    public Object getKeyCert() {
        return this.keyCert;
    }

    public void setKeyCert(String keyCert) {
        this.keyCert = keyCert;
    }

    public void setKeyCert(InputStream keyCert) {
        this.keyCert = keyCert;
    }

    public InputStream getKeyPublicCertInputStream() throws IOException {
        return this.certStoreType.getInputStream(this.keyPublicCert);
    }

    public InputStream getKeyCertInputStream() throws IOException {
        return this.certStoreType.getInputStream(this.keyCert);
    }

    public CertStoreType getCertStoreType() {
        return this.certStoreType;
    }

    public void setCertStoreType(CertStoreType certStoreType) {
        this.certStoreType = certStoreType;
    }
}

