/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.merchant.bean;

import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.paypal.api.PayPalConfigStorage;
import com.egzosn.pay.spring.boot.core.PayConfigurerAdapter;
import com.egzosn.pay.spring.boot.core.builders.InMemoryMerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformServiceAdapter;
import com.egzosn.pay.spring.boot.core.provider.merchant.platform.PaymentPlatforms;

public class PaypalMerchantDetails
extends PayPalConfigStorage
implements PaymentPlatformMerchantDetails,
PaymentPlatformServiceAdapter,
PayConfigurerAdapter<InMemoryMerchantDetailsServiceBuilder> {
    private String detailsId;
    private volatile PayService payService;
    private PaymentPlatform platform;
    private InMemoryMerchantDetailsServiceBuilder builder;
    private HttpConfigStorage httpConfigStorage;

    @Override
    public InMemoryMerchantDetailsServiceBuilder and() {
        this.initService();
        return this.getBuilder();
    }

    @Override
    public InMemoryMerchantDetailsServiceBuilder getBuilder() {
        return this.builder;
    }

    public PaypalMerchantDetails(InMemoryMerchantDetailsServiceBuilder builder) {
        this();
        this.builder = builder;
    }

    public PaypalMerchantDetails() {
        String platformName = "paypalPay";
        this.setPayType(platformName);
        this.platform = PaymentPlatforms.getPaymentPlatform(platformName);
    }

    @Override
    public PaymentPlatform getPaymentPlatform() {
        return this.platform;
    }

    @Override
    public PaymentPlatformServiceAdapter initService() {
        if (null == this.payService) {
            this.payService = this.platform.getPayService(this, this.getHttpConfigStorage());
        }
        return this;
    }

    public PayService getPayService() {
        return this.payService;
    }

    @Override
    public HttpConfigStorage getHttpConfigStorage() {
        return this.httpConfigStorage;
    }

    public PaypalMerchantDetails httpConfigStorage(HttpConfigStorage httpConfigStorage) {
        this.httpConfigStorage = httpConfigStorage;
        return this;
    }

    @Override
    public String getDetailsId() {
        return this.detailsId;
    }

    public PaypalMerchantDetails detailsId(String detailsId) {
        this.detailsId = detailsId;
        return this;
    }

    public PaypalMerchantDetails signType(String signType) {
        this.setSignType(signType);
        return this;
    }

    public PaypalMerchantDetails inputCharset(String inputCharset) {
        this.setInputCharset(inputCharset);
        return this;
    }

    public PaypalMerchantDetails test(boolean test) {
        this.setTest(test);
        return this;
    }

    public PaypalMerchantDetails clientID(String clientID) {
        this.setClientID(clientID);
        return this;
    }

    public PaypalMerchantDetails clientSecret(String clientSecret) {
        this.setClientSecret(clientSecret);
        return this;
    }

    public PaypalMerchantDetails cancelUrl(String cancelUrl) {
        this.setNotifyUrl(cancelUrl);
        return this;
    }

    public PaypalMerchantDetails returnUrl(String returnUrl) {
        this.setReturnUrl(returnUrl);
        return this;
    }
}

