/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.merchant.bean;

import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.CertStoreType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.PayConfigurerAdapter;
import com.egzosn.pay.spring.boot.core.builders.InMemoryMerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformServiceAdapter;
import com.egzosn.pay.spring.boot.core.provider.merchant.platform.PaymentPlatforms;
import com.egzosn.pay.wx.v3.api.WxPayConfigStorage;

public class WxV3MerchantDetails
extends WxPayConfigStorage
implements PaymentPlatformMerchantDetails,
PaymentPlatformServiceAdapter,
PayConfigurerAdapter<InMemoryMerchantDetailsServiceBuilder> {
    private String detailsId;
    private volatile PayService payService;
    private PaymentPlatform platform;
    private InMemoryMerchantDetailsServiceBuilder builder;
    private HttpConfigStorage httpConfigStorage;

    @Override
    public InMemoryMerchantDetailsServiceBuilder and() {
        this.initService();
        return this.getBuilder();
    }

    @Override
    public InMemoryMerchantDetailsServiceBuilder getBuilder() {
        return this.builder;
    }

    public WxV3MerchantDetails(InMemoryMerchantDetailsServiceBuilder builder) {
        this();
        this.builder = builder;
    }

    public WxV3MerchantDetails() {
        String platformName = "wxV3Pay";
        this.initPaymentPlatforms(platformName);
    }

    public WxV3MerchantDetails initPaymentPlatforms(String platformName) {
        this.setPayType(platformName);
        this.platform = PaymentPlatforms.getPaymentPlatform(platformName);
        return this;
    }

    @Override
    public PaymentPlatform getPaymentPlatform() {
        return this.platform;
    }

    @Override
    public PaymentPlatformServiceAdapter initService() {
        if (null == this.payService) {
            this.payService = this.platform.getPayService(this, this.getHttpConfigStorage());
        }
        return this;
    }

    public PayService getPayService() {
        return this.payService;
    }

    @Override
    public HttpConfigStorage getHttpConfigStorage() {
        return this.httpConfigStorage;
    }

    public WxV3MerchantDetails httpConfigStorage(HttpConfigStorage httpConfigStorage) {
        this.httpConfigStorage = httpConfigStorage;
        return this;
    }

    @Override
    public String getDetailsId() {
        return this.detailsId;
    }

    public WxV3MerchantDetails detailsId(String detailsId) {
        this.detailsId = detailsId;
        return this;
    }

    public WxV3MerchantDetails notifyUrl(String notifyUrl) {
        this.setNotifyUrl(notifyUrl);
        return this;
    }

    public WxV3MerchantDetails returnUrl(String returnUrl) {
        this.setReturnUrl(returnUrl);
        return this;
    }

    public WxV3MerchantDetails signType(String signType) {
        this.setSignType(signType);
        return this;
    }

    public WxV3MerchantDetails inputCharset(String inputCharset) {
        this.setInputCharset(inputCharset);
        return this;
    }

    public WxV3MerchantDetails test(boolean test) {
        this.setTest(test);
        return this;
    }

    public WxV3MerchantDetails appId(String appId) {
        this.setAppId(appId);
        return this;
    }

    public WxV3MerchantDetails v3ApiKey(String v3ApiKey) {
        this.setV3ApiKey(v3ApiKey);
        return this;
    }

    public WxV3MerchantDetails apiKey(String apiKey) {
        this.setApiKey(apiKey);
        return this;
    }

    public WxV3MerchantDetails keyPublic(String keyPublic) {
        this.setKeyPublic(keyPublic);
        return this;
    }

    public WxV3MerchantDetails mchId(String mchId) {
        this.setMchId(mchId);
        return this;
    }

    public WxV3MerchantDetails subAppId(String subAppId) {
        this.setSubAppId(subAppId);
        return this;
    }

    public WxV3MerchantDetails subMchId(String subMchId) {
        this.setSubMchId(subMchId);
        return this;
    }

    public WxV3MerchantDetails apiClientKeyP12(Object apiClientKeyP12) {
        this.setApiClientKeyP12(apiClientKeyP12);
        return this;
    }

    public WxV3MerchantDetails certStoreType(CertStoreType certStoreType) {
        this.setCertStoreType(certStoreType);
        return this;
    }
}

