/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider;

import com.egzosn.pay.common.bean.CertStoreType;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.spring.boot.core.configurers.PayMessageConfigurer;
import com.egzosn.pay.spring.boot.core.merchant.MerchantNotFoundException;
import com.egzosn.pay.spring.boot.core.merchant.bean.CommonPaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.provider.InMemoryMerchantDetailsManager;
import com.egzosn.pay.spring.boot.core.provider.MerchantDetailsManager;
import com.egzosn.pay.spring.boot.core.utils.SqlTools;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class JdbcMerchantDetailsManager
implements MerchantDetailsManager<CommonPaymentPlatformMerchantDetails> {
    private static final String TABLE = "merchant_details";
    private static final List<String> FIELDS = Arrays.asList("appid", "pay_type", "mch_id", "cert_store_type", "key_private", "key_cert_pwd", "key_public", "key_cert", "notify_url", "return_url", "sign_type", "seller", "sub_app_id", "sub_mch_id", "input_charset", "is_test");
    private static final String SELECT_FIELDS = SqlTools.join(FIELDS, ", ");
    private static final String ID = "details_id";
    private static final String DEFAULT_BASE_QUERY_SQL = SqlTools.getSelectSQL("details_id, " + SELECT_FIELDS, "merchant_details");
    private static final String DEFAULT_FIND_BY_ID_SQL = DEFAULT_BASE_QUERY_SQL + " where " + "details_id" + "=?";
    private static final String DEFAULT_INSERT_SQL = "insert into merchant_details (details_id, " + SELECT_FIELDS + ") values (" + SqlTools.forQuestionMarkSQL(FIELDS.size() + 1) + ")";
    private static final String DEFAULT_UPDATE_SQL = SqlTools.generateUpdateByRowIdString("merchant_details", FIELDS, "details_id").toString();
    private static final String DEFAULT_DELETE_SQL = "delete from merchant_details where details_id=?";
    public static final String DEFAULT_EXISTS_SQL = "select details_id from merchant_details where details_id = ?";
    private JdbcTemplate jdbcTemplate;
    private String findByIdSql = DEFAULT_FIND_BY_ID_SQL;
    private String insertSql = DEFAULT_INSERT_SQL;
    private String updateSql = DEFAULT_UPDATE_SQL;
    private String deleteSql = "delete from merchant_details where details_id=?";
    private String existsSql = "select details_id from merchant_details where details_id = ?";
    private PayMessageConfigurer configurer;

    public JdbcMerchantDetailsManager(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public JdbcMerchantDetailsManager(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void createMerchant(Collection<CommonPaymentPlatformMerchantDetails> merchants) {
        for (CommonPaymentPlatformMerchantDetails merchant : merchants) {
            this.createMerchant(merchant);
        }
    }

    @Override
    public void createMerchant(CommonPaymentPlatformMerchantDetails merchant) {
        Assert.isTrue((!this.merchantExists(merchant.getDetailsId()) ? 1 : 0) != 0, (String)"\u5546\u6237\u4fe1\u606f\u5df2\u5b58\u5728");
        Object[] args = new Object[]{merchant.getDetailsId(), merchant.getAppId(), merchant.getPayType(), merchant.getMchId(), merchant.getCertStoreType(), merchant.getKeyPrivate(), merchant.getKeyPrivateCertPwd(), merchant.getKeyPublic(), merchant.getKeyCert(), merchant.getNotifyUrl(), merchant.getReturnUrl(), merchant.getSignType(), merchant.getSeller(), merchant.getSubAppId(), merchant.getSubMchId(), merchant.getInputCharset(), merchant.isTest()};
        this.jdbcTemplate.update(this.insertSql, args);
    }

    @Override
    public void updateMerchant(CommonPaymentPlatformMerchantDetails merchant) {
        Assert.isTrue((boolean)this.merchantExists(merchant.getDetailsId()), (String)"\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        Object[] args = new Object[]{merchant.getAppId(), merchant.getPayType(), merchant.getMchId(), merchant.getCertStoreType(), merchant.getKeyPrivate(), merchant.getKeyPrivateCertPwd(), merchant.getKeyPublic(), merchant.getKeyCert(), merchant.getNotifyUrl(), merchant.getReturnUrl(), merchant.getSignType(), merchant.getSeller(), merchant.getSubAppId(), merchant.getSubMchId(), merchant.getInputCharset(), merchant.isTest(), merchant.getDetailsId()};
        this.jdbcTemplate.update(this.updateSql, args);
    }

    @Override
    public void deleteMerchant(String id) {
        this.jdbcTemplate.update(this.deleteSql, new Object[]{id});
    }

    @Override
    public boolean merchantExists(String merchantId) {
        List ids = this.jdbcTemplate.queryForList(this.existsSql, String.class, new Object[]{merchantId});
        if (ids.size() > 1) {
            throw new IncorrectResultSizeDataAccessException("\u51fa\u73b0\u91cd\u590d\u7684\u652f\u4ed8\u5546\u6237id", 1);
        }
        return !ids.isEmpty();
    }

    @Override
    public CommonPaymentPlatformMerchantDetails loadMerchantByMerchantId(String merchantId) {
        int size;
        List detailss = this.jdbcTemplate.query(this.findByIdSql, (rs, i) -> {
            CommonPaymentPlatformMerchantDetails details = new CommonPaymentPlatformMerchantDetails();
            details.setDetailsId(rs.getString(1));
            details.setAppId(rs.getString(2));
            details.setPayType(rs.getString(3));
            details.setMchId(rs.getString(4));
            String certStoreType = rs.getString(5);
            if (StringUtils.isNotEmpty((CharSequence)certStoreType)) {
                details.setCertStoreType(CertStoreType.valueOf((String)certStoreType));
            }
            if (details.getCertStoreType() == CertStoreType.INPUT_STREAM) {
                this.setKeyPrivate(details, rs);
                details.setKeyCert(rs.getAsciiStream(9));
            } else {
                details.setKeystore(rs.getString(6));
                details.setKeyPublicCert(rs.getString(8));
                details.setKeyCert(rs.getString(9));
            }
            details.setKeystorePwd(rs.getString(7));
            details.setNotifyUrl(rs.getString(10));
            details.setReturnUrl(rs.getString(11));
            details.setSignType(rs.getString(12));
            details.setSeller(rs.getString(13));
            details.setSubAppId(rs.getString(14));
            details.setSubMchId(rs.getString(15));
            details.setInputCharset(rs.getString(16));
            details.setTest(rs.getBoolean(17));
            Object payService = details.initService().getPayService();
            InMemoryMerchantDetailsManager.setPayMessageConfigurer(payService, details, this.configurer);
            return details;
        }, new Object[]{merchantId});
        int n = size = detailss != null ? detailss.size() : 0;
        if (size == 0) {
            throw new MerchantNotFoundException(merchantId);
        }
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return (CommonPaymentPlatformMerchantDetails)detailss.get(0);
    }

    public void setKeyPrivate(CommonPaymentPlatformMerchantDetails details, ResultSet rs) throws SQLException {
        if ("unionPay".equals(details.getPayType())) {
            details.setKeystore(rs.getAsciiStream(6));
            details.setKeyPublicCert(rs.getAsciiStream(8));
        } else {
            details.setKeyPrivate(rs.getString(6));
            details.setKeyPublic(rs.getString(8));
        }
    }

    public String getFindByIdSql() {
        return this.findByIdSql;
    }

    public void setFindByIdSql(String findByIdSql) {
        this.findByIdSql = findByIdSql;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public void setInsertSql(String insertSql) {
        this.insertSql = insertSql;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public String getDeleteSql() {
        return this.deleteSql;
    }

    public void setDeleteSql(String deleteSql) {
        this.deleteSql = deleteSql;
    }

    public String getExistsSql() {
        return this.existsSql;
    }

    public void setExistsSql(String existsSql) {
        this.existsSql = existsSql;
    }

    @Override
    public void setPayMessageConfigurer(PayMessageConfigurer configurer) {
        this.configurer = configurer;
    }
}

