/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider.merchant.platform;

import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.CertStoreType;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.bean.CommonPaymentPlatformMerchantDetails;
import com.egzosn.pay.wx.api.WxPayConfigStorage;
import com.egzosn.pay.wx.api.WxPayService;
import com.egzosn.pay.wx.bean.WxTransactionType;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="wxPay")
@ConditionalOnMissingBean(value={WxPaymentPlatform.class})
@ConditionalOnClass(name={"com.egzosn.pay.wx.api.WxPayConfigStorage"})
public class WxPaymentPlatform
extends WxPayConfigStorage
implements PaymentPlatform {
    protected final Log LOG = LogFactory.getLog(WxPaymentPlatform.class);
    public static final String PLATFORM_NAME = "wxPay";
    @Deprecated
    public static final String platformName = "wxPay";

    @Override
    public String getPlatform() {
        return "wxPay";
    }

    public PayService getPayService(PayConfigStorage payConfigStorage) {
        return this.getPayService(payConfigStorage, null);
    }

    public PayService getPayService(PayConfigStorage payConfigStorage, HttpConfigStorage httpConfigStorage) {
        if (payConfigStorage instanceof WxPayConfigStorage) {
            WxPayService wxPayService = new WxPayService((WxPayConfigStorage)payConfigStorage);
            wxPayService.setRequestTemplateConfigStorage(httpConfigStorage);
            return wxPayService;
        }
        WxPayConfigStorage configStorage = new WxPayConfigStorage();
        configStorage.setInputCharset(payConfigStorage.getInputCharset());
        configStorage.setAppId(payConfigStorage.getAppId());
        configStorage.setMchId(payConfigStorage.getPid());
        configStorage.setAttach(payConfigStorage.getAttach());
        configStorage.setKeyPrivate(payConfigStorage.getKeyPrivate());
        configStorage.setKeyPublic(payConfigStorage.getKeyPublic());
        configStorage.setNotifyUrl(payConfigStorage.getNotifyUrl());
        configStorage.setReturnUrl(payConfigStorage.getReturnUrl());
        configStorage.setPayType(payConfigStorage.getPayType());
        configStorage.setTest(payConfigStorage.isTest());
        configStorage.setSignType(payConfigStorage.getSignType());
        if (payConfigStorage instanceof CommonPaymentPlatformMerchantDetails) {
            CommonPaymentPlatformMerchantDetails merchantDetails = (CommonPaymentPlatformMerchantDetails)payConfigStorage;
            configStorage.setSubAppId(merchantDetails.getSubAppId());
            configStorage.setSubMchId(merchantDetails.getSubMchId());
            if (null != merchantDetails.getKeyCert()) {
                if (null == httpConfigStorage) {
                    httpConfigStorage = new HttpConfigStorage();
                }
                httpConfigStorage.setCertStoreType(merchantDetails.getCertStoreType());
                try {
                    httpConfigStorage.setKeystore(merchantDetails.getKeyCertInputStream());
                }
                catch (IOException e) {
                    this.LOG.error((Object)e);
                }
                httpConfigStorage.setCertStoreType(CertStoreType.INPUT_STREAM);
                httpConfigStorage.setStorePassword(merchantDetails.getKeystorePwd());
            }
        }
        WxPayService wxPayService = new WxPayService(configStorage);
        wxPayService.setRequestTemplateConfigStorage(httpConfigStorage);
        return wxPayService;
    }

    public TransactionType getTransactionType(String name) {
        return WxTransactionType.valueOf((String)name);
    }
}

