/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.utils;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlTools {
    public static final String SEPARATED = ", ";
    private static final Pattern PATTERN = Pattern.compile(":([0-9A-Za-z_]+)[, ]?");

    public static String getCountSQL(String sql) {
        return SqlTools.getCountSQL(sql, null);
    }

    public static String getCountOracleSQL(String sql) {
        return SqlTools.getCountOracleSQL(sql, null);
    }

    public static String getCountSQL(String sql, String countField) {
        String countSql = String.format("SELECT  COUNT(%s) ", null == countField ? "*" : countField);
        String upperSql = sql.toUpperCase();
        int start = upperSql.indexOf("FROM ");
        int end = upperSql.lastIndexOf("ORDER BY ");
        countSql = countSql + sql.substring(start, end == -1 ? sql.length() : end);
        return countSql;
    }

    public static String getCountOracleSQL(String sql, String countField) {
        String countSql = String.format("SELECT  COUNT(%s) ", null == countField ? "*" : countField);
        String upperSql = sql.toUpperCase().replace("SELECT * FROM ( ", "").replace(" ) WHERE ROWNUM BETWEEN %s AND %s", "");
        int start = upperSql.indexOf("FROM ");
        int end = upperSql.lastIndexOf("ORDER BY ");
        countSql = countSql + sql.substring(start, end == -1 ? sql.length() : end);
        return countSql;
    }

    public static String removeGROUP(String sql) {
        String upperSql = sql.toUpperCase();
        int end = upperSql.indexOf(" GROUP ");
        return -1 == end ? sql : sql.substring(0, end);
    }

    public static String getSelectSQL(String select, String tableName) {
        if (null == select || "".equals(select)) {
            select = "*";
        }
        return String.format("select %s from %s ", select, tableName);
    }

    public static String getSQL(String select, String tableName, String alias, String where) {
        return String.format("%s %s %s", SqlTools.getSelectSQL(select, tableName), alias, where);
    }

    public static String forPaginate(int pageNumber, int pageSize) {
        int offset = pageSize * (pageNumber - 1);
        return String.format(" limit %s,%s", offset, pageSize);
    }

    public static String forPaginate(String sql, int pageNumber, int pageSize) {
        int offset = pageSize * (pageNumber - 1);
        String sqltmp = String.format("SELECT *  FROM (SELECT ROWNUM  RN,a.* FROM (  %s  ) a  WHERE ROWNUM <= %s) WHERE RN >%s", sql, offset + pageSize, offset);
        return sqltmp;
    }

    public static void fillStatement(PreparedStatement ps, List<Object> params) throws SQLException {
        if (null == params || params.isEmpty()) {
            return;
        }
        int i = 0;
        for (Object param : params) {
            if (param instanceof List) {
                SqlTools.fillStatement(ps, (List)param);
                ps.addBatch();
                continue;
            }
            if (param instanceof Object[]) {
                SqlTools.fillStatement(ps, (Object[])param);
                ps.addBatch();
                continue;
            }
            if (null == param) {
                ps.setNull(++i, 1111);
                continue;
            }
            ps.setObject(++i, param);
        }
    }

    public static void fillStatement(PreparedStatement ps, Object ... params) throws SQLException {
        if (null == params) {
            return;
        }
        if (params instanceof Object[][]) {
            for (Object[] v : (Object[][])params) {
                SqlTools.fillStatement(ps, v);
                ps.addBatch();
            }
        } else {
            int i = 0;
            for (Object param : params) {
                if (null == param) {
                    ps.setNull(++i, 1111);
                    continue;
                }
                ps.setObject(++i, param);
            }
        }
    }

    public static StringBuilder generateInsertString(String tableName, List<String> keyColumnNames) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tableName).append("(");
        StringBuilder temp = new StringBuilder(") values(");
        boolean flag = false;
        for (String colName : keyColumnNames) {
            if (flag) {
                sql.append(SEPARATED);
                temp.append(SEPARATED);
            }
            sql.append("").append(colName).append("");
            temp.append("?");
            flag = true;
        }
        return sql.append(temp.toString()).append(")");
    }

    public static StringBuilder generateUpdateByRowIdString(String tableName, List<String> keyColumnNames, String idColumn) {
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(tableName).append(" set ");
        int i = 0;
        for (String colName : keyColumnNames) {
            if (i != 0) {
                sql.append(SEPARATED);
            }
            sql.append("").append(colName).append(" = ? ");
            ++i;
        }
        sql.append(" where ").append(idColumn).append(" = ?");
        return sql;
    }

    public static StringBuilder forMapSave(String table, Map<String, Object> attrs, List<Object> paras) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(table).append("(");
        StringBuilder temp = new StringBuilder(") values(");
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            if (null == entry.getValue()) continue;
            if (paras.size() > 0) {
                sql.append(SEPARATED);
                temp.append(SEPARATED);
            }
            sql.append(' ').append(entry.getKey()).append(' ');
            temp.append("?");
            paras.add(entry.getValue());
        }
        sql.append((CharSequence)temp).append(")");
        return sql;
    }

    public static StringBuilder forMapUpdate(String table, Map<String, Object> attrs, String where, List<Object> whereVal, List<Object> paras) {
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(table).append(" set ");
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            if (!paras.isEmpty()) {
                sql.append(SEPARATED);
            }
            sql.append(' ').append(entry.getKey()).append(" = ? ");
            paras.add(entry.getValue());
        }
        sql.append(where);
        paras.addAll(whereVal);
        return sql;
    }

    public static StringBuilder forMapUpdate(String table, Map<String, Object> attrs, Map<String, Object> where, List<Object> paras) {
        boolean flag = false;
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(table).append(" set ");
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            if (flag) {
                sql.append(SEPARATED);
            }
            sql.append(' ').append(entry.getKey()).append(" = ? ");
            paras.add(entry.getValue());
            flag = true;
        }
        sql.append(" where ");
        for (Map.Entry<String, Object> entry : where.entrySet()) {
            if (!flag) {
                sql.append(" and ");
            }
            sql.append(' ').append(entry.getKey()).append(" = ? ");
            paras.add(entry.getValue());
            flag = false;
        }
        return sql;
    }

    public static String forConverSQL(String sql, Map<String, Object> attrs, List<Object> values) {
        Matcher matcher = PATTERN.matcher(sql);
        String rexp = null;
        while (matcher.find()) {
            String group = matcher.group(1);
            Object ov = attrs.get(group);
            if (ov instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                Collection vs = (Collection)ov;
                for (Object v : vs) {
                    sb.append("?,");
                    values.add(v);
                }
                sb.deleteCharAt(sb.length() - 1);
                rexp = sb.toString();
            } else {
                values.add(ov);
                rexp = "?";
            }
            sql = sql.replace(String.format(":%s", group), rexp);
        }
        return sql;
    }

    public static String forQuestionMarkSQL(int num) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String join(List<String> list, String separated) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (sb.length() != 0) {
                sb.append(separated);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }
}

