/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2017 Paweł Cesar Sanjuan Szklarz
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

package com.eiipii.esddd.eventsourcing.eventstore.sql

import java.sql.Connection

object EventStoreSqlConfiguration {

}

case class EventStoreSqlConfiguration(dbConfig: EventStoreDatabaseConfig)

case class EventStoreDatabaseConfig(
  connectionPoolSymbol:      Symbol,
  dialect:                   EventStoreSqlDialect,
  tablesNamespace:           String,
  rebuildDDL:                Boolean                                = false,
  transactionIsolationLevel: EventStoreSqlTransactionIsolationLevel = ReadCommitted
)

sealed trait EventStoreSqlDialect

case object H2EventStoreSqlDialect extends EventStoreSqlDialect

case object MySqlEventStoreSqlDialect extends EventStoreSqlDialect

case object PostgresEventStoreSqlDialect extends EventStoreSqlDialect

sealed trait EventStoreSqlTransactionIsolationLevel {
  def jdbcValue: Int
}

case object ReadCommitted extends EventStoreSqlTransactionIsolationLevel {
  override def jdbcValue: Int = Connection.TRANSACTION_READ_COMMITTED
}

case object Serializable extends EventStoreSqlTransactionIsolationLevel {
  override def jdbcValue: Int = Connection.TRANSACTION_SERIALIZABLE
}