/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.autoscaler.systemhistorians.opentsdb;

import com.elastisys.autoscaler.core.api.types.MetricValue;
import com.elastisys.scale.commons.util.precond.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class OpenTsdbDataPointRepresenter {
    private static final String NON_WHITESPACE_REGEX = "\\S+";

    public static String representDataPoint(MetricValue dataPoint) {
        Objects.requireNonNull(dataPoint, "Data point cannot be null");
        Preconditions.checkArgument((!dataPoint.getTags().isEmpty() ? 1 : 0) != 0, (String)"data point needs at least one tag", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(dataPoint.getMetric());
        sb.append(' ').append(dataPoint.getTime().getMillis() / TimeUnit.SECONDS.toMillis(1L));
        sb.append(' ').append(dataPoint.getValue());
        for (String tagKey : dataPoint.getTags().keySet()) {
            Preconditions.checkArgument((boolean)tagKey.matches(NON_WHITESPACE_REGEX), (String)"tag key must be a simple alphanumeric string, not %s", (Object[])new Object[]{tagKey});
            String tagValue = (String)dataPoint.getTags().get(tagKey);
            Preconditions.checkArgument((boolean)tagKey.matches(NON_WHITESPACE_REGEX), (String)"tag value must be a simple alphanumeric string, not {}", (Object[])new Object[]{tagValue});
            sb.append(' ').append(tagKey).append('=').append(tagValue);
        }
        return sb.toString();
    }
}

