/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.autoscaler.systemhistorians.opentsdb;

import com.elastisys.autoscaler.core.api.types.MetricValue;
import com.elastisys.autoscaler.systemhistorians.opentsdb.OpenTsdbDataPointRepresenter;
import com.elastisys.autoscaler.systemhistorians.opentsdb.OpenTsdbException;
import com.elastisys.autoscaler.systemhistorians.opentsdb.OpenTsdbInserter;
import com.elastisys.scale.commons.util.concurrent.Sleep;
import com.elastisys.scale.commons.util.io.IoUtils;
import com.elastisys.scale.commons.util.precond.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class OpenTsdbSocketInserter
implements OpenTsdbInserter {
    private final Logger logger;
    private final String host;
    private final int port;

    public OpenTsdbSocketInserter(Logger logger, String host, int port) {
        Objects.requireNonNull(logger, "logger cannot be null");
        Objects.requireNonNull(host, "OpenTSDB host cannot be null");
        Preconditions.checkArgument((!host.isEmpty() ? 1 : 0) != 0, (String)"OpenTSDB host cannot be empty", (Object[])new Object[0]);
        Preconditions.checkArgument((1 <= port && port <= 65353 ? 1 : 0) != 0, (String)"Port number not in allowed range [1,65353]", (Object[])new Object[0]);
        this.host = host;
        this.port = port;
        this.logger = logger;
    }

    @Override
    public void insert(MetricValue value) throws OpenTsdbException {
        Objects.requireNonNull(value, "value cannot be null");
        Socket socket = null;
        try {
            socket = this.connect();
            String telnetCommand = "put " + OpenTsdbDataPointRepresenter.representDataPoint(value) + "\n";
            this.write(socket, telnetCommand);
            Optional<String> response = this.awaitResponse(socket, 100L);
            if (response.isPresent()) {
                throw new OpenTsdbException(String.format("OpenTSDB responded with error: '%s'", response.get()));
            }
        }
        catch (Exception e) {
            throw new OpenTsdbException(String.format("failed to post data to OpenTSDB server %s:%d: '%s'", this.host, this.port, e.getMessage()), e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    new RuntimeException(e);
                }
            }
        }
    }

    private Socket connect() throws OpenTsdbException {
        try {
            return new Socket(this.host, this.port);
        }
        catch (IOException e) {
            throw new OpenTsdbException(String.format("failed to connect to OpenTSDB %s:%d: %s", this.host, this.port, e.getMessage()), e);
        }
    }

    private void write(Socket socket, String data) throws IOException, OpenTsdbException {
        try {
            OutputStream output = socket.getOutputStream();
            output.write(data.getBytes());
            output.flush();
            socket.shutdownOutput();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("wrote to {}:{}: [{}]", new Object[]{this.host, this.port, data});
            }
        }
        catch (Exception e) {
            throw new OpenTsdbException(String.format("failed to write to %s:%d: %s", this.host, this.port, e.getMessage()), e);
        }
    }

    private Optional<String> awaitResponse(Socket socket, long millis) throws IOException, OpenTsdbException {
        Optional<String> optional;
        Sleep.forTime((long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
        InputStreamReader reader = new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8);
        try {
            Optional<String> response = Optional.empty();
            InputStream input = socket.getInputStream();
            if (input.available() > 0) {
                response = Optional.of(IoUtils.toString((Reader)reader).trim());
                this.logger.debug("OpenTSDB error response: '{}'", (Object)response.get());
            }
            optional = response;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new OpenTsdbException(String.format("failed to read from %s:%d: %s", this.host, this.port, e.getMessage()), e);
            }
        }
        ((Reader)reader).close();
        return optional;
    }
}

