/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.autoscaler.systemhistorians.opentsdb;

import com.elastisys.autoscaler.core.api.types.MetricValue;
import com.elastisys.autoscaler.core.api.types.ServiceStatus;
import com.elastisys.autoscaler.core.autoscaler.AutoScalerMetadata;
import com.elastisys.autoscaler.core.monitoring.systemhistorian.api.SystemHistorian;
import com.elastisys.autoscaler.core.monitoring.systemhistorian.api.SystemHistorianFlushException;
import com.elastisys.autoscaler.core.monitoring.systemhistorian.api.types.SystemMetricEvent;
import com.elastisys.autoscaler.systemhistorians.opentsdb.OpenTsdbInserter;
import com.elastisys.autoscaler.systemhistorians.opentsdb.OpenTsdbSocketInserter;
import com.elastisys.autoscaler.systemhistorians.opentsdb.config.OpenTsdbSystemHistorianConfig;
import com.elastisys.scale.commons.eventbus.EventBus;
import com.elastisys.scale.commons.eventbus.Subscriber;
import com.elastisys.scale.commons.util.precond.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;

public class OpenTsdbSystemHistorian
implements SystemHistorian<OpenTsdbSystemHistorianConfig> {
    private final UUID autoScalerUuid;
    private final String autoScalerId;
    private final Logger logger;
    private final ScheduledExecutorService executorService;
    private final EventBus eventBus;
    private final ConcurrentLinkedQueue<MetricValue> unreportedDatapoints;
    private DataPointPusher pusher;
    private ScheduledFuture<?> ongoingPusher;
    private OpenTsdbSystemHistorianConfig configuration;

    @Inject
    public OpenTsdbSystemHistorian(@Named(value="Uuid") UUID autoScalerUuid, @Named(value="AutoScalerId") String autoScalerId, Logger logger, ScheduledExecutorService executorService, EventBus eventBus) {
        this.autoScalerUuid = autoScalerUuid;
        this.autoScalerId = autoScalerId;
        this.logger = logger;
        this.executorService = executorService;
        this.eventBus = eventBus;
        this.unreportedDatapoints = new ConcurrentLinkedQueue();
        this.pusher = null;
        this.configuration = null;
    }

    public void validate(OpenTsdbSystemHistorianConfig configuration) throws IllegalArgumentException {
        Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"systemHistorian: configuration cannot be null", (Object[])new Object[0]);
        configuration.validate();
    }

    public synchronized void configure(OpenTsdbSystemHistorianConfig configuration) throws IllegalArgumentException {
        this.validate(configuration);
        OpenTsdbSocketInserter newInserter = new OpenTsdbSocketInserter(this.logger, configuration.getOpenTsdbHost(), configuration.getOpenTsdbPort());
        DataPointPusher newPusher = new DataPointPusher(this.logger, newInserter, this.unreportedDatapoints);
        if (this.isStarted()) {
            this.stop();
            this.configuration = configuration;
            this.pusher = newPusher;
            this.start();
        } else {
            this.configuration = configuration;
            this.pusher = newPusher;
        }
    }

    public synchronized void start() {
        Preconditions.checkState((this.getConfiguration() != null ? 1 : 0) != 0, (String)"attempt to start before configuring", (Object[])new Object[0]);
        if (this.isStarted()) {
            this.logger.info(this.getClass().getSimpleName() + " already started, ignoring request.");
            return;
        }
        this.eventBus.register((Object)this);
        long interval = this.getConfiguration().getPushInterval().getSeconds();
        this.ongoingPusher = this.executorService.scheduleWithFixedDelay(() -> this.flush(), interval, interval, TimeUnit.SECONDS);
        this.logger.info(this.getClass().getSimpleName() + " started.");
    }

    private boolean isStarted() {
        return this.ongoingPusher != null;
    }

    public synchronized void stop() {
        if (!this.isStarted()) {
            this.logger.info(this.getClass().getSimpleName() + " already stopped, ignoring request.");
            return;
        }
        this.eventBus.unregister((Object)this);
        this.ongoingPusher.cancel(false);
        this.ongoingPusher = null;
        this.logger.info(this.getClass().getSimpleName() + " stopped.");
    }

    public ServiceStatus getStatus() {
        ServiceStatus.Builder builder = new ServiceStatus.Builder().started(this.isStarted());
        if (this.pusher != null) {
            builder.lastFault(this.pusher.getLastError());
        }
        return builder.build();
    }

    public OpenTsdbSystemHistorianConfig getConfiguration() {
        return this.configuration;
    }

    public Class<OpenTsdbSystemHistorianConfig> getConfigurationClass() {
        return OpenTsdbSystemHistorianConfig.class;
    }

    @Subscriber
    public void onEvent(SystemMetricEvent event) {
        MetricValue qualifiedEvent = event.getValue().withTags(AutoScalerMetadata.metricTags((UUID)this.autoScalerUuid, (String)this.autoScalerId));
        this.logger.debug("received event: {}", (Object)qualifiedEvent);
        this.unreportedDatapoints.add(qualifiedEvent);
    }

    public void flush() throws SystemHistorianFlushException {
        this.ensureStarted();
        this.pusher.run();
    }

    private void ensureStarted() {
        Preconditions.checkState((boolean)this.isStarted(), (String)"attempt to use system historian before being started", (Object[])new Object[0]);
    }

    int getDeliveredDataPoints() {
        DataPointPusher dataPointPusher = this.pusher;
        if (dataPointPusher == null) {
            return 0;
        }
        return dataPointPusher.getDeliveredDataPoints();
    }

    private class DataPointPusher
    implements Runnable {
        private final Logger logger;
        private final OpenTsdbInserter opentsdbInserter;
        private final Queue<MetricValue> unreportedDatapoints;
        private Optional<? extends Throwable> lastError;
        private int deliveredDataPoints = 0;
        private final Lock lock = new ReentrantLock();

        public DataPointPusher(Logger logger, OpenTsdbInserter opentsdbInserter, ConcurrentLinkedQueue<MetricValue> unreportedDatapoints) {
            Objects.requireNonNull(logger, "logger is null");
            Objects.requireNonNull(opentsdbInserter, "OpenTSDB inserter is null");
            Objects.requireNonNull(unreportedDatapoints, "data point queue is null");
            this.logger = logger;
            this.opentsdbInserter = opentsdbInserter;
            this.unreportedDatapoints = unreportedDatapoints;
            this.lastError = Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.lastError = Optional.empty();
            try {
                this.lock.lock();
                ArrayList<MetricValue> pointsToInsert = new ArrayList<MetricValue>(this.unreportedDatapoints);
                if (pointsToInsert.isEmpty()) {
                    return;
                }
                ArrayList<MetricValue> successfullyInserted = new ArrayList<MetricValue>();
                for (MetricValue dataPoint : pointsToInsert) {
                    try {
                        this.opentsdbInserter.insert(dataPoint);
                        successfullyInserted.add(dataPoint);
                    }
                    catch (Exception e) {
                        this.logger.error(String.format("failed to push data point to OpenTSDB: %s", e.getMessage()), (Throwable)e);
                    }
                }
                this.unreportedDatapoints.removeAll(successfullyInserted);
                if (!successfullyInserted.equals(pointsToInsert)) {
                    throw new IOException(String.format("only inserted %d of %d data points", successfullyInserted.size(), pointsToInsert.size()));
                }
                this.logger.debug(String.format("successfully pushed %d data points", successfullyInserted.size()));
                this.deliveredDataPoints += successfullyInserted.size();
            }
            catch (Exception e) {
                this.logger.error("failed to post data points to OpenTSDB: " + e.getMessage(), (Throwable)e);
                this.lastError = Optional.of(e);
            }
            finally {
                this.lock.unlock();
            }
        }

        public Optional<? extends Throwable> getLastError() {
            return this.lastError;
        }

        int getDeliveredDataPoints() {
            return this.deliveredDataPoints;
        }
    }
}

