/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.autoscaler.systemhistorians.opentsdb.config;

import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.json.types.TimeInterval;
import com.elastisys.scale.commons.util.precond.Preconditions;
import com.google.gson.JsonElement;
import java.util.Objects;
import java.util.Optional;

public class OpenTsdbSystemHistorianConfig {
    public static final TimeInterval DEFAULT_PUSH_INTERVAL = TimeInterval.seconds((long)30L);
    public static final int DEFAULT_OPENTSDB_PORT = 4242;
    private final String openTsdbHost;
    private final Integer openTsdbPort;
    private final TimeInterval pushInterval;

    public OpenTsdbSystemHistorianConfig(String openTsdbHost, Integer openTsdbPort, TimeInterval pushInterval) {
        this.openTsdbHost = openTsdbHost;
        this.openTsdbPort = openTsdbPort;
        this.pushInterval = pushInterval;
    }

    public String getOpenTsdbHost() {
        return this.openTsdbHost;
    }

    public int getOpenTsdbPort() {
        return Optional.ofNullable(this.openTsdbPort).orElse(4242);
    }

    public TimeInterval getPushInterval() {
        return Optional.ofNullable(this.pushInterval).orElse(DEFAULT_PUSH_INTERVAL);
    }

    public void validate() throws IllegalArgumentException {
        try {
            Objects.requireNonNull(this.openTsdbHost, "openTsdbHost missing");
            Preconditions.checkArgument((1 <= this.getOpenTsdbPort() && this.getOpenTsdbPort() <= 65353 ? 1 : 0) != 0, (String)"openTsdbPort not in allowed range [1,65353]", (Object[])new Object[0]);
            Preconditions.checkArgument((this.getPushInterval().getSeconds() >= 1L ? 1 : 0) != 0, (String)"pushInterval must be a positive duration", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("systemHistorian: " + e.getMessage(), e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.openTsdbHost, this.openTsdbPort, this.pushInterval);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OpenTsdbSystemHistorianConfig) {
            OpenTsdbSystemHistorianConfig that = (OpenTsdbSystemHistorianConfig)obj;
            return Objects.equals(this.openTsdbHost, that.openTsdbHost) && Objects.equals(this.openTsdbPort, that.openTsdbPort) && Objects.equals(this.pushInterval, that.pushInterval);
        }
        return false;
    }

    public String toString() {
        return JsonUtils.toString((JsonElement)JsonUtils.toJson((Object)this));
    }
}

