/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nbj;

import com.electronwill.nbj.tagtypes.TagType;
import com.electronwill.nbj.tagtypes.Types;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;

public class Tag<V> {
    protected final TagType<V> type;
    protected String name;
    protected V value;

    public Tag(TagType<V> type, String name, V value) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public void writeNameless(DataOutput output) throws IOException {
        output.writeByte(this.type.id());
        this.type.writeValue(this.value, output);
    }

    public void writeNamed(DataOutput output) throws IOException {
        output.writeByte(this.type.id());
        Types.STRING.writeValue(this.name, output);
        this.type.writeValue(this.value, output);
    }

    public TagType<V> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public V getValue() {
        return this.value;
    }

    public static Tag<?> readNamed(DataInput input) throws IOException {
        byte typeId = input.readByte();
        TagType<?> type = Types.get(typeId);
        String name = Types.STRING.readValue(input);
        Object value = type.readValue(input);
        return new Tag(type, name, value);
    }

    public static Tag<?> readNamed(InputStream input) throws IOException {
        DataInput dataInput = input instanceof DataInput ? (DataInput)((Object)input) : new DataInputStream(input);
        return Tag.readNamed(dataInput);
    }

    public static Tag<?> readNameless(DataInput input) throws IOException {
        byte typeId = input.readByte();
        TagType<?> type = Types.get(typeId);
        Object value = type.readValue(input);
        return new Tag(type, "", value);
    }

    public static Tag<?> readNameless(InputStream input) throws IOException {
        DataInput dataInput = input instanceof DataInput ? (DataInput)((Object)input) : new DataInputStream(input);
        return Tag.readNameless(dataInput);
    }
}

