/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nbj.tagtypes;

import com.electronwill.nbj.NbtException;
import com.electronwill.nbj.tagtypes.TagType;
import com.electronwill.nbj.tagtypes.TypeByte;
import com.electronwill.nbj.tagtypes.TypeByteArray;
import com.electronwill.nbj.tagtypes.TypeCompound;
import com.electronwill.nbj.tagtypes.TypeDouble;
import com.electronwill.nbj.tagtypes.TypeEnd;
import com.electronwill.nbj.tagtypes.TypeFloat;
import com.electronwill.nbj.tagtypes.TypeInt;
import com.electronwill.nbj.tagtypes.TypeIntArray;
import com.electronwill.nbj.tagtypes.TypeIterable;
import com.electronwill.nbj.tagtypes.TypeIterator;
import com.electronwill.nbj.tagtypes.TypeList;
import com.electronwill.nbj.tagtypes.TypeLong;
import com.electronwill.nbj.tagtypes.TypeLongArray;
import com.electronwill.nbj.tagtypes.TypeObjArray;
import com.electronwill.nbj.tagtypes.TypeShort;
import com.electronwill.nbj.tagtypes.TypeString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Types {
    public static final TypeEnd END = new TypeEnd();
    public static final TagType<Byte> BYTE = new TypeByte();
    public static final TagType<Short> SHORT = new TypeShort();
    public static final TagType<Integer> INT = new TypeInt();
    public static final TagType<Long> LONG = new TypeLong();
    public static final TagType<Float> FLOAT = new TypeFloat();
    public static final TagType<Double> DOUBLE = new TypeDouble();
    public static final TagType<byte[]> BYTE_ARRAY = new TypeByteArray();
    public static final TagType<String> STRING = new TypeString();
    public static final TagType<List<?>> LIST = new TypeList();
    public static final TagType<Map<String, Object>> COMPOUND = new TypeCompound();
    public static final TagType<int[]> INT_ARRAY = new TypeIntArray();
    public static final TagType<long[]> LONG_ARRAY = new TypeLongArray();
    public static final TagType<Object[]> OBJ_ARRAY = new TypeObjArray();
    public static final TagType<Iterable<?>> ITERABLE = new TypeIterable();
    public static final TagType<Iterator<?>> ITERATOR = new TypeIterator();
    private static final TagType<?>[] TYPES = new TagType[]{END, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, BYTE_ARRAY, STRING, LIST, COMPOUND, INT_ARRAY, LONG_ARRAY};

    private Types() {
    }

    public static TagType<?> get(int id) {
        return TYPES[id];
    }

    public static <T> TagType<? super T> forValue(T o) {
        if (o == null) {
            return END;
        }
        if (o instanceof int[]) {
            return INT_ARRAY;
        }
        if (o instanceof long[]) {
            return LONG_ARRAY;
        }
        if (o instanceof byte[]) {
            return BYTE_ARRAY;
        }
        if (o instanceof Object[]) {
            return OBJ_ARRAY;
        }
        if (o instanceof Map) {
            return COMPOUND;
        }
        if (o instanceof List) {
            return LIST;
        }
        if (o instanceof Iterable) {
            return ITERABLE;
        }
        if (o instanceof Iterator) {
            return ITERATOR;
        }
        Class<?> clazz = o.getClass();
        if (clazz == String.class) {
            return STRING;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return INT;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return BYTE;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return SHORT;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return LONG;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return FLOAT;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return DOUBLE;
        }
        throw new NbtException("Illegal NBT object type: " + o.getClass().getCanonicalName());
    }
}

