/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.niol.buffer;

import com.electronwill.niol.Utils$;
import com.electronwill.niol.buffer.CircularBuffer$;
import com.electronwill.niol.buffer.NiolBuffer;
import com.electronwill.niol.buffer.storage.BytesStorage;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t5a!\u0002\u00192\u0003\u0003Q\u0004\u0002C \u0001\u0005\u000b\u0007K\u0011\u0003!\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u0005C\u0001b\u0012\u0001\u0003\u0002\u0004&\t\u0002\u0013\u0005\t\u001f\u0002\u0011\t\u0019)C\t!\"Aa\u000b\u0001B\u0001B\u0003&\u0011\n\u0003\u0005X\u0001\t\u0005\r\u0015\"\u0005I\u0011!A\u0006A!a!\n#I\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0015B%\t\u0011q\u0003!\u00111Q\u0005\u0012uC\u0001\"\u0019\u0001\u0003\u0002\u0004&\tB\u0019\u0005\tI\u0002\u0011\t\u0011)Q\u0005=\")Q\r\u0001C\tM\")A\u000e\u0001C!\u0011\")Q\u000e\u0001C!\u0011\")a\u000e\u0001C!\u0011\")q\u000e\u0001C!;\")\u0001\u000f\u0001C!;\")\u0011\u000f\u0001D\te\")q\u000f\u0001D\tq\"1Q\u0010\u0001C)gyDq! \u0001\u0005RM\n)\u0001C\u0004~\u0001\u0011E3'!\u0007\t\u000fu\u0004A\u0011K\u001a\u00020!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA\u001b\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003k\u0001A\u0011IA-\u0011!\ti\u0006\u0001C)g\u0005}\u0003\u0002CA/\u0001\u0011E3'a\u0019\t\u0011\u0005u\u0003\u0001\"\u00154\u0003[Bq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002t\u0001!\t%a\u001f\t\u000f\u0005M\u0004\u0001\"\u0011\u0002\u0006\"9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBA:\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\t\t\u000b\u0001C!\u0003GCq!a*\u0001\t\u0003\nI\u000bC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011q\u0017\u0001\u0005B\u0005evaBAic!\u0005\u00111\u001b\u0004\u0007aEB\t!!6\t\r\u0015TC\u0011AAo\u0011!\tyN\u000bC\u0001c\u0005\u0005\bbBApU\u0011\u0005\u00111\u001f\u0005\b\u0003oTC\u0011AA}\u0011\u001d\t9P\u000bC\u0001\u0003\u007f\u0014abQ5sGVd\u0017M\u001d\"vM\u001a,'O\u0003\u00023g\u00051!-\u001e4gKJT!\u0001N\u001b\u0002\t9Lw\u000e\u001c\u0006\u0003m]\nA\"\u001a7fGR\u0014xN\\<jY2T\u0011\u0001O\u0001\u0004G>l7\u0001A\n\u0003\u0001m\u0002\"\u0001P\u001f\u000e\u0003EJ!AP\u0019\u0003\u00159Kw\u000e\u001c\"vM\u001a,'/A\u0004ti>\u0014\u0018mZ3\u0016\u0003\u0005\u0003\"A\u0011#\u000e\u0003\rS!aP\u0019\n\u0005\u0015\u001b%\u0001\u0004\"zi\u0016\u001c8\u000b^8sC\u001e,\u0017\u0001C:u_J\fw-\u001a\u0011\u0002\u000fI,\u0017\r\u001a9pgV\t\u0011\n\u0005\u0002K\u001b6\t1JC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5JA\u0002J]R\f1B]3bIB|7o\u0018\u0013fcR\u0011\u0011\u000b\u0016\t\u0003\u0015JK!aU&\u0003\tUs\u0017\u000e\u001e\u0005\b+\u0012\t\t\u00111\u0001J\u0003\rAH%M\u0001\te\u0016\fG\r]8tA\u0005AqO]5uKB|7/\u0001\u0007xe&$X\r]8t?\u0012*\u0017\u000f\u0006\u0002R5\"9QkBA\u0001\u0002\u0004I\u0015!C<sSR,\u0007o\\:!\u0003-a\u0017m\u001d;Pa^\u0013\u0018\u000e^3\u0016\u0003y\u0003\"AS0\n\u0005\u0001\\%a\u0002\"p_2,\u0017M\\\u0001\u0010Y\u0006\u001cHo\u00149Xe&$Xm\u0018\u0013fcR\u0011\u0011k\u0019\u0005\b+*\t\t\u00111\u0001_\u00031a\u0017m\u001d;Pa^\u0013\u0018\u000e^3!\u0003\u0019a\u0014N\\5u}Q)q\r[5kWB\u0011A\b\u0001\u0005\u0006\u007f1\u0001\r!\u0011\u0005\u0006\u000f2\u0001\r!\u0013\u0005\u0006/2\u0001\r!\u0013\u0005\u000692\u0001\rAX\u0001\tG\u0006\u0004\u0018mY5us\u0006i!/Z1eC\ndWMQ=uKN\fQb\u001e:ji\u0006\u0014G.\u001a\"zi\u0016\u001c\u0018aB5t\u000b6\u0004H/_\u0001\u0007SN4U\u000f\u001c7\u0002\u001b\r|WO\u001c;DSJ\u001cW\u000f\\1s)\rI5/\u001e\u0005\u0006iJ\u0001\r!S\u0001\u0006E\u0016<\u0017N\u001c\u0005\u0006mJ\u0001\r!S\u0001\u0004K:$\u0017aC1eI\u000eK'oY;mCJ$2!S=|\u0011\u0015Q8\u00031\u0001J\u0003\u0005\t\u0007\"\u0002?\u0014\u0001\u0004I\u0015!\u00012\u0002\u000b}\u0013X-\u00193\u0015\u0003}\u00042ASA\u0001\u0013\r\t\u0019a\u0013\u0002\u0005\u0005f$X\rF\u0004R\u0003\u000f\t\t\"!\u0006\t\u000f\u0005%Q\u00031\u0001\u0002\f\u0005\u0011Ao\u001c\t\u0005\u0015\u00065q0C\u0002\u0002\u0010-\u0013Q!\u0011:sCfDa!a\u0005\u0016\u0001\u0004I\u0015aA8gM\"1\u0011qC\u000bA\u0002%\u000b1\u0001\\3o)\u0015\t\u00161DA\u0017\u0011\u001d\tIA\u0006a\u0001\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0002oS>T!!a\n\u0002\t)\fg/Y\u0005\u0005\u0003W\t\tC\u0001\u0006CsR,')\u001e4gKJDa!a\u0006\u0017\u0001\u0004IE#B)\u00022\u0005M\u0002BBA\u0005/\u0001\u00071\b\u0003\u0004\u0002\u0018]\u0001\r!S\u0001\te\u0016\fGmU8nKR\u0019\u0011*!\u000f\t\u000f\u0005m\u0002\u00041\u0001\u0002>\u0005\u0019Am\u001d;\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003RA!a\u0011\u0002\"\u0005A1\r[1o]\u0016d7/\u0003\u0003\u0002H\u0005\u0005#\u0001F$bi\",'/\u001b8h\u0005f$Xm\u00115b]:,G\u000eF\u0002J\u0003\u0017Bq!a\u000f\u001a\u0001\u0004\ti\u0005\u0005\u0003\u0002P\u0005USBAA)\u0015\u0011\t\u0019&!\n\u0002\u0005%|\u0017\u0002BA,\u0003#\u0012AbT;uaV$8\u000b\u001e:fC6$2!SA.\u0011\u0019\tYD\u0007a\u0001w\u00051ql\u001e:ji\u0016$2!UA1\u0011\u0015a8\u00041\u0001\u0000)\u001d\t\u0016QMA5\u0003WBq!a\u001a\u001d\u0001\u0004\tY!\u0001\u0003ge>l\u0007BBA\n9\u0001\u0007\u0011\n\u0003\u0004\u0002\u0018q\u0001\r!\u0013\u000b\u0006#\u0006=\u0014\u0011\u000f\u0005\b\u0003Oj\u0002\u0019AA\u000f\u0011\u0019\t9\"\ba\u0001\u0013\u0006IqO]5uKN{W.\u001a\u000b\u0004\u0013\u0006]\u0004bBA==\u0001\u0007\u0011QD\u0001\u0004gJ\u001cGcA%\u0002~!9\u0011\u0011P\u0010A\u0002\u0005}\u0004\u0003BA \u0003\u0003KA!a!\u0002B\t)2kY1ui\u0016\u0014\u0018N\\4CsR,7\t[1o]\u0016dGcA%\u0002\b\"9\u0011\u0011\u0010\u0011A\u0002\u0005%\u0005\u0003BA(\u0003\u0017KA!!$\u0002R\tY\u0011J\u001c9viN#(/Z1n\u0003\u00159(/\u001b;f)\r\t\u00161\u0013\u0005\u0007\u0003s\n\u0003\u0019A\u001e\u0015\u0007%\u000b9\n\u0003\u0004\u0002z\t\u0002\raO\u0001\u0006g2L7-\u001a\u000b\u0004w\u0005u\u0005BBAPG\u0001\u0007\u0011*\u0001\u0004mK:<G\u000f[\u0001\u000eoJLG/\u00192mKNc\u0017nY3\u0015\u0007m\n)\u000b\u0003\u0004\u0002 \u0012\u0002\r!S\u0001\nIV\u0004H.[2bi\u0016,\u0012aO\u0001\u0006G2,\u0017M\u001d\u000b\u0002#\u00069\u0011\r\u001a<b]\u000e,GcA)\u00024\"1\u0011QW\u0014A\u0002%\u000b\u0011A\\\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0018\t\u0005\u0003{\u000bYM\u0004\u0003\u0002@\u0006\u001d\u0007cAAa\u00176\u0011\u00111\u0019\u0006\u0004\u0003\u000bL\u0014A\u0002\u001fs_>$h(C\u0002\u0002J.\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAg\u0003\u001f\u0014aa\u0015;sS:<'bAAe\u0017\u0006q1)\u001b:dk2\f'OQ;gM\u0016\u0014\bC\u0001\u001f+'\rQ\u0013q\u001b\t\u0004\u0015\u0006e\u0017bAAn\u0017\n1\u0011I\\=SK\u001a$\"!a5\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013\u001d\f\u0019/a:\u0002l\u0006=\bBBAsY\u0001\u0007\u0011)A\u0001t\u0011\u0019\tI\u000f\fa\u0001\u0013\u0006\t!\u000f\u0003\u0004\u0002n2\u0002\r!S\u0001\u0002o\"1\u0011\u0011\u001f\u0017A\u0002y\u000b\u0011\u0001\u001c\u000b\u0004O\u0006U\b\"B .\u0001\u0004\t\u0015\u0001B<sCB$2aZA~\u0011\u001d\tiP\fa\u0001\u0003;\t!A\u00192\u0015\u000f\u001d\u0014\tA!\u0002\u0003\n!9!1A\u0018A\u0002\u0005-\u0011!\u00022zi\u0016\u001c\bB\u0002B\u0004_\u0001\u0007\u0011*\u0001\u0006sK\u0006$wJ\u001a4tKRDaAa\u00030\u0001\u0004I\u0015A\u0003:fC\u0012dUM\\4uQ\u0002")
public abstract class CircularBuffer
extends NiolBuffer {
    private final BytesStorage storage;
    private int readpos;
    private int writepos;
    private boolean lastOpWrite;

    public static CircularBuffer wrap(byte[] byArray, int n, int n2) {
        return CircularBuffer$.MODULE$.wrap(byArray, n, n2);
    }

    public static CircularBuffer wrap(ByteBuffer byteBuffer) {
        return CircularBuffer$.MODULE$.wrap(byteBuffer);
    }

    public static CircularBuffer apply(BytesStorage bytesStorage) {
        return CircularBuffer$.MODULE$.apply(bytesStorage);
    }

    public BytesStorage storage() {
        return this.storage;
    }

    public int readpos() {
        return this.readpos;
    }

    public void readpos_$eq(int x$1) {
        this.readpos = x$1;
    }

    public int writepos() {
        return this.writepos;
    }

    public void writepos_$eq(int x$1) {
        this.writepos = x$1;
    }

    public boolean lastOpWrite() {
        return this.lastOpWrite;
    }

    public void lastOpWrite_$eq(boolean x$1) {
        this.lastOpWrite = x$1;
    }

    @Override
    public int capacity() {
        return this.storage().capacity();
    }

    @Override
    public int readableBytes() {
        return this.isFull() ? this.capacity() : this.countCircular(this.readpos(), this.writepos());
    }

    @Override
    public int writableBytes() {
        return this.isEmpty() ? this.capacity() : this.countCircular(this.writepos(), this.readpos());
    }

    @Override
    public boolean isEmpty() {
        return this.readpos() == this.writepos() && !this.lastOpWrite();
    }

    @Override
    public boolean isFull() {
        return this.readpos() == this.writepos() && this.lastOpWrite();
    }

    public abstract int countCircular(int var1, int var2);

    public abstract int addCircular(int var1, int var2);

    @Override
    public byte _read() {
        int p = this.readpos();
        this.readpos_$eq(this.addCircular(p, 1));
        this.lastOpWrite_$eq(false);
        return this.storage().get1(p);
    }

    @Override
    public void _read(byte[] to, int off, int len) {
        int w;
        int p = this.readpos();
        if (p < (w = this.writepos())) {
            this.storage().get(p, to, off, len);
        } else {
            int right = this.capacity() - p;
            if (right >= len) {
                this.storage().get(p, to, off, len);
            } else {
                this.storage().get(p, to, off, right);
                this.storage().get(0, to, off + right, len - right);
            }
        }
        this.readpos_$eq(this.addCircular(p, len));
        this.lastOpWrite_$eq(false);
    }

    @Override
    public void _read(ByteBuffer to, int len) {
        int w;
        int p = this.readpos();
        if (p < (w = this.writepos())) {
            this.storage().get(p, to, len);
        } else {
            int right = this.capacity() - p;
            if (right >= len) {
                this.storage().get(p, to, len);
            } else {
                this.storage().get(p, to, right);
                this.storage().get(0, to, len - right);
            }
        }
        this.readpos_$eq(this.addCircular(p, len));
        this.lastOpWrite_$eq(false);
    }

    @Override
    public void _read(NiolBuffer to, int len) {
        int p = this.readpos();
        int w = this.writepos();
        ByteBuffer bb = this.storage().byteBuffer();
        bb.position(p);
        if (p < w) {
            to._write(bb, len);
        } else {
            int right = this.capacity() - p;
            if (right >= len) {
                to._write(bb, len);
            } else {
                to._write(bb, right);
                bb.position(0);
                to._write(bb, len - right);
            }
        }
        this.readpos_$eq(this.addCircular(p, len));
        this.lastOpWrite_$eq(false);
    }

    @Override
    public int readSome(GatheringByteChannel dst) {
        int read;
        block4: {
            int n;
            int w;
            int len = this.readableBytes();
            int r = this.readpos();
            if (r < (w = this.writepos())) {
                n = this.storage().get(r, dst, len);
            } else {
                int right = this.capacity() - r;
                if (right >= len) {
                    n = this.storage().get(r, dst, len);
                } else {
                    int rRight = this.storage().get(r, dst, right);
                    int rLeft = this.storage().get(0, dst, len - right);
                    n = read = rRight + rLeft;
                }
            }
            if (read <= 0) break block4;
            this.readpos_$eq(this.addCircular(r, read));
            this.lastOpWrite_$eq(false);
        }
        return read;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readSome(OutputStream dst) {
        void var2_2;
        int len = package$.MODULE$.min(this.readableBytes(), 4096);
        byte[] buff = new byte[len];
        this._read(buff, 0, len);
        dst.write(buff);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readSome(NiolBuffer dst) {
        void var2_2;
        int len = package$.MODULE$.min(this.readableBytes(), dst.writableBytes());
        this._read(dst, len);
        return (int)var2_2;
    }

    @Override
    public void _write(byte b) {
        int p = this.writepos();
        this.writepos_$eq(this.addCircular(p, 1));
        this.lastOpWrite_$eq(true);
        this.storage().put1(p, b);
    }

    @Override
    public void _write(byte[] from, int off, int len) {
        int r;
        int w = this.writepos();
        if (w < (r = this.readpos())) {
            this.storage().put(w, from, off, len);
            this.writepos_$eq(this.addCircular(w, len));
        } else if (w == r) {
            Predef$.MODULE$.assert(this.isEmpty());
            this.storage().put(0, from, off, len);
            this.readpos_$eq(0);
            this.writepos_$eq(len);
        } else {
            int l = package$.MODULE$.min(len, this.capacity() - w);
            this.storage().put(w, from, off, l);
            this.storage().put(0, from, off + l, len - l);
            this.writepos_$eq(this.addCircular(w, len));
        }
        this.lastOpWrite_$eq(true);
    }

    @Override
    public void _write(ByteBuffer from, int len) {
        int r;
        int w = this.writepos();
        if (w < (r = this.readpos())) {
            this.storage().put(w, from, len);
            this.writepos_$eq(this.addCircular(w, len));
        } else if (w == r) {
            Predef$.MODULE$.assert(this.isEmpty());
            this.storage().put(0, from, len);
            this.readpos_$eq(0);
            this.writepos_$eq(len);
        } else {
            int l = package$.MODULE$.min(len, this.capacity() - w);
            this.storage().put(w, from, l);
            this.storage().put(0, from, len - l);
            this.writepos_$eq(this.addCircular(w, len));
        }
        this.lastOpWrite_$eq(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeSome(ByteBuffer src) {
        void var2_2;
        int len = package$.MODULE$.min(src.remaining(), this.writableBytes());
        this._write(src, len);
        return (int)var2_2;
    }

    @Override
    public int writeSome(ScatteringByteChannel src) {
        int written;
        block7: {
            int n;
            int r;
            if (this.isFull()) {
                return 0;
            }
            int maxLen = this.writableBytes();
            int w = this.writepos();
            if (w < (r = this.readpos())) {
                n = this.storage().put(w, src, maxLen);
            } else if (w == r) {
                Predef$.MODULE$.assert(this.isEmpty());
                this.readpos_$eq(0);
                w = 0;
                n = this.storage().put(0, src, maxLen);
            } else {
                int l = package$.MODULE$.min(maxLen, this.capacity() - w);
                int wRight = this.storage().put(w, src, l);
                if (wRight > 0) {
                    int wLeft = this.storage().put(0, src, maxLen - l);
                    n = wRight + Utils$.MODULE$.positively(wLeft);
                } else {
                    n = written = wRight;
                }
            }
            if (written <= 0) break block7;
            this.writepos_$eq(this.addCircular(w, written));
            this.lastOpWrite_$eq(true);
        }
        return written;
    }

    @Override
    public int writeSome(InputStream src) {
        int written;
        block9: {
            int n;
            if (this.isFull()) {
                return 0;
            }
            int maxLen = this.writableBytes();
            int w = this.writepos();
            int r = this.readpos();
            if (this.storage().byteBuffer().hasArray()) {
                byte[] arr = this.storage().byteBuffer().array();
                if (w < r) {
                    n = src.read(arr, w, maxLen);
                } else if (w == r) {
                    Predef$.MODULE$.assert(this.isEmpty());
                    this.readpos_$eq(0);
                    w = 0;
                    n = src.read(arr, 0, maxLen);
                } else {
                    int l = package$.MODULE$.min(maxLen, this.capacity() - w);
                    int wRight = src.read(arr, w, l);
                    if (wRight > 0) {
                        int wLeft = src.read(arr, 0, maxLen - l);
                        n = wRight + Utils$.MODULE$.positively(wLeft);
                    } else {
                        n = wRight;
                    }
                }
            } else {
                byte[] arr = new byte[package$.MODULE$.min(maxLen, 4096)];
                n = written = src.read(arr);
            }
            if (written <= 0) break block9;
            this.writepos_$eq(this.addCircular(w, written));
            this.lastOpWrite_$eq(true);
        }
        return written;
    }

    @Override
    public void write(NiolBuffer src) {
        src.read(this);
    }

    @Override
    public int writeSome(NiolBuffer src) {
        return src.readSome(this);
    }

    @Override
    public NiolBuffer slice(int length) {
        this.checkReadable(length);
        int end = this.addCircular(this.readpos(), length);
        return CircularBuffer$.MODULE$.apply(this.storage(), this.readpos(), end, this.isFull());
    }

    @Override
    public NiolBuffer writableSlice(int length) {
        this.checkWritable(length);
        int end = this.addCircular(this.writepos(), length);
        return CircularBuffer$.MODULE$.apply(this.storage(), end, this.writepos(), this.isEmpty());
    }

    @Override
    public NiolBuffer duplicate() {
        return CircularBuffer$.MODULE$.apply(this.storage(), this.readpos(), this.writepos(), this.lastOpWrite());
    }

    @Override
    public void clear() {
        this.readpos_$eq(0);
        this.writepos_$eq(0);
        this.lastOpWrite_$eq(false);
    }

    @Override
    public void advance(int n) {
        int r = this.readableBytes();
        if (n > r) {
            throw new IndexOutOfBoundsException(new StringBuilder(40).append("Cannot advance by ").append(n).append(" bytes: only ").append(r).append(" readable").toString());
        }
        this.readpos_$eq(this.addCircular(this.readpos(), n));
        this.lastOpWrite_$eq(false);
    }

    @Override
    public String toString() {
        return new StringBuilder(13).append(super.toString()).append(" and (r=").append(this.readpos()).append(", w=").append(this.writepos()).append(")").toString();
    }

    public CircularBuffer(BytesStorage storage, int readpos, int writepos, boolean lastOpWrite) {
        this.storage = storage;
        this.readpos = readpos;
        this.writepos = writepos;
        this.lastOpWrite = lastOpWrite;
    }
}

