/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.niol.buffer.storage;

import com.electronwill.collection.RecyclingIndex;
import com.electronwill.niol.buffer.storage.BufferAllocationException;
import com.electronwill.niol.buffer.storage.BytesStorage;
import com.electronwill.niol.buffer.storage.StoragePool$;
import com.electronwill.niol.buffer.storage.StorageReference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u000e\u001d\u0001\u001dB\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tg\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001BC\u0002\u0013\u0005q\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00031\u0011!1\u0004A!b\u0001\n\u00039\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011q\u0002!Q1A\u0005\u0002]B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011)\u0019!C\u0005_!Aq\b\u0001B\u0001B\u0003%\u0001\u0007C\u0003A\u0001\u0011\u0005\u0011\t\u0003\u0004J\u0001\u0001\u0006IA\u0013\u0005\u0007/\u0002\u0001\u000b\u0011\u0002-\t\r\u0005\u0004\u0001\u0015!\u0003c\u0011\u0019Y\u0007\u0001)Q\u0005a!)A\u000e\u0001C\u0001[\"1a\u000e\u0001C\u00019=Daa\u001e\u0001!\n\u0013A\bB\u0002?\u0001A\u0013%\u0001\u0010\u0003\u0004~\u0001\u0001&IA \u0005\b\u0003\u0003\u0001\u0001\u0015\"\u0003y\u0011!\t\u0019\u0001\u0001Q\u0005\n\u0005\u0015q!CA\u00049\u0005\u0005\t\u0012AA\u0005\r!YB$!A\t\u0002\u0005-\u0001B\u0002!\u0019\t\u0003\ti\u0001C\u0005\u0002\u0010a\t\n\u0011\"\u0001\u0002\u0012\tY1\u000b^8sC\u001e,\u0007k\\8m\u0015\tib$A\u0004ti>\u0014\u0018mZ3\u000b\u0005}\u0001\u0013A\u00022vM\u001a,'O\u0003\u0002\"E\u0005!a.[8m\u0015\t\u0019C%\u0001\u0007fY\u0016\u001cGO]8oo&dGNC\u0001&\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\ra>|GnQ1qC\u000eLG/_\u000b\u0002aA\u0011\u0011&M\u0005\u0003e)\u00121!\u00138u\u00035\u0001xn\u001c7DCB\f7-\u001b;zA\u0005q!-\u001e4gKJ\u001c\u0015\r]1dSRL\u0018a\u00042vM\u001a,'oQ1qC\u000eLG/\u001f\u0011\u0002/%\u001cXj\u001c:f\u00032dwnY1uS>t\u0017\t\u001c7po\u0016$W#\u0001\u001d\u0011\u0005%J\u0014B\u0001\u001e+\u0005\u001d\u0011un\u001c7fC:\f\u0001$[:N_J,\u0017\t\u001c7pG\u0006$\u0018n\u001c8BY2|w/\u001a3!\u0003!I7\u000fR5sK\u000e$\u0018!C5t\t&\u0014Xm\u0019;!\u0003M\u0011XM\u001a)s_\u000e,7o]5oOB+'oR3u\u0003Q\u0011XM\u001a)s_\u000e,7o]5oOB+'oR3uA\u00051A(\u001b8jiz\"bA\u0011#F\r\u001eC\u0005CA\"\u0001\u001b\u0005a\u0002\"\u0002\u0018\f\u0001\u0004\u0001\u0004\"\u0002\u001b\f\u0001\u0004\u0001\u0004\"\u0002\u001c\f\u0001\u0004A\u0004\"\u0002\u001f\f\u0001\u0004A\u0004b\u0002 \f!\u0003\u0005\r\u0001M\u0001\u0007O\u000e\u0014VMZ:\u0011\u0007-\u0013F+D\u0001M\u0015\tie*A\u0002sK\u001aT!a\u0014)\u0002\t1\fgn\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019FJ\u0001\bSK\u001a,'/\u001a8dKF+X-^3\u0011\u0005\r+\u0016B\u0001,\u001d\u00051\u0011\u0015\u0010^3t'R|'/Y4f\u0003)\t7\r^5wKJ+gm\u001d\t\u00043rsV\"\u0001.\u000b\u0005m\u0013\u0013AC2pY2,7\r^5p]&\u0011QL\u0017\u0002\u000f%\u0016\u001c\u0017p\u00197j]\u001eLe\u000eZ3y!\t\u0019u,\u0003\u0002a9\t\u00012\u000b^8sC\u001e,'+\u001a4fe\u0016t7-Z\u0001\fMJ,WMQ;gM\u0016\u00148\u000fE\u0002*G\u0016L!\u0001\u001a\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019LW\"A4\u000b\u0005!\u0004\u0016a\u00018j_&\u0011!n\u001a\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018a\u00044sK\u0016\u0014UO\u001a4fe\u000e{WO\u001c;\u0002\u0007\u001d,G\u000fF\u0001U\u0003\u001d\u0001X\u000f\u001e\"bG.$2\u0001]:v!\tI\u0013/\u0003\u0002sU\t!QK\\5u\u0011\u0015!\u0018\u00031\u00011\u0003\tIG\rC\u0003w#\u0001\u0007Q-\u0001\u0002cE\u0006!\u0002O]8dKN\u001c8i\u001c7mK\u000e$X\r\u001a*fMN$\u0012!\u001f\t\u0004Si,\u0017BA>+\u0005\u0019y\u0005\u000f^5p]\u0006y\u0001o\u001c7m\u001fJ\fE\r\u001a\"vM\u001a,'/A\u0006pM\u001a,'OQ;gM\u0016\u0014HC\u0001\u001d\u0000\u0011\u0015yB\u00031\u0001f\u00031\tG\r\u001a(fo\n+hMZ3s\u00039\tG\u000e\\8dCR,')\u001e4gKJ$\u0012!Z\u0001\f'R|'/Y4f!>|G\u000e\u0005\u0002D1M\u0011\u0001\u0004\u000b\u000b\u0003\u0003\u0013\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAA\nU\r\u0001\u0014QC\u0016\u0003\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0005\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005m!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class StoragePool {
    private final int poolCapacity;
    private final int bufferCapacity;
    private final boolean isMoreAllocationAllowed;
    private final boolean isDirect;
    private final int refProcessingPerGet;
    private final ReferenceQueue<BytesStorage> gcRefs;
    private final RecyclingIndex<StorageReference> activeRefs;
    private final ByteBuffer[] freeBuffers;
    private int freeBufferCount;

    public static int $lessinit$greater$default$5() {
        return StoragePool$.MODULE$.$lessinit$greater$default$5();
    }

    public int poolCapacity() {
        return this.poolCapacity;
    }

    public int bufferCapacity() {
        return this.bufferCapacity;
    }

    public boolean isMoreAllocationAllowed() {
        return this.isMoreAllocationAllowed;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    private int refProcessingPerGet() {
        return this.refProcessingPerGet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized BytesStorage get() {
        boolean bl = false;
        Option option = null;
        Option option2 = this.processCollectedRefs().orElse((Function0 & java.io.Serializable & Serializable)() -> this.pollOrAddBuffer());
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            ByteBuffer buffer = (ByteBuffer)some.value();
            BytesStorage sto = new BytesStorage(buffer, this);
            StorageReference ref = new StorageReference(buffer, sto, this.gcRefs);
            sto.id_$eq(this.activeRefs.$plus$eq((Object)ref));
            return sto;
        }
        if (None$.MODULE$.equals(option2)) {
            bl = true;
            option = option2;
            if (this.isMoreAllocationAllowed()) {
                return new BytesStorage(this.allocateBuffer(), this);
            }
        }
        if (!bl) throw new MatchError((Object)option2);
        throw new BufferAllocationException();
    }

    public void putBack(int id, ByteBuffer bb) {
        StoragePool storagePool = this;
        synchronized (storagePool) {
            this.activeRefs.remove(id);
            this.offerBuffer(bb);
        }
    }

    private Option<ByteBuffer> processCollectedRefs() {
        StorageReference ref = (StorageReference)this.gcRefs.poll();
        for (int i = 0; i <= this.refProcessingPerGet() && ref != null; ++i) {
            this.offerBuffer(ref.bb());
            ref = (StorageReference)this.gcRefs.poll();
        }
        return Option$.MODULE$.apply((Object)ref).map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.bb());
    }

    private synchronized Option<ByteBuffer> pollOrAddBuffer() {
        Some some;
        int n = this.freeBufferCount--;
        switch (n) {
            case 0: {
                some = this.addNewBuffer();
                break;
            }
            default: {
                ByteBuffer buff = this.freeBuffers[n - 1];
                some = new Some((Object)buff);
                break;
            }
        }
        return some;
    }

    private boolean offerBuffer(ByteBuffer buffer) {
        boolean bl;
        if (this.freeBufferCount < this.freeBuffers.length) {
            this.freeBuffers[this.freeBufferCount] = buffer;
            ++this.freeBufferCount;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private Option<ByteBuffer> addNewBuffer() {
        None$ none$;
        if (this.activeRefs.size() < this.poolCapacity()) {
            ByteBuffer buffer;
            this.freeBuffers[this.freeBufferCount] = buffer = this.allocateBuffer();
            ++this.freeBufferCount;
            none$ = new Some((Object)buffer);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private ByteBuffer allocateBuffer() {
        return this.isDirect() ? ByteBuffer.allocate(this.bufferCapacity()) : ByteBuffer.allocateDirect(this.bufferCapacity());
    }

    public StoragePool(int poolCapacity, int bufferCapacity, boolean isMoreAllocationAllowed, boolean isDirect, int refProcessingPerGet) {
        this.poolCapacity = poolCapacity;
        this.bufferCapacity = bufferCapacity;
        this.isMoreAllocationAllowed = isMoreAllocationAllowed;
        this.isDirect = isDirect;
        this.refProcessingPerGet = refProcessingPerGet;
        this.gcRefs = new ReferenceQueue();
        this.activeRefs = new RecyclingIndex(poolCapacity, ClassTag$.MODULE$.apply(StorageReference.class));
        this.freeBuffers = new ByteBuffer[poolCapacity];
        this.freeBufferCount = 0;
    }
}

