/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.plugins.gallery;

import com.elepy.ElepyPostConfiguration;
import com.elepy.admin.concepts.ElepyAdminPanelPlugin;
import com.elepy.http.HttpService;
import com.elepy.plugins.gallery.ImageDao;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mongodb.DB;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElepyGallery
extends ElepyAdminPanelPlugin {
    private static final Logger logger = LoggerFactory.getLogger(ElepyGallery.class);

    public ElepyGallery() {
        super("Gallery", "/images");
    }

    public void setup(HttpService http, ElepyPostConfiguration elepy) {
        ImageDao imageDao = new ImageDao((DB)elepy.getDependency(DB.class));
        http.post(elepy.getBaseSlug() + "/images/upload", (request, response) -> {
            try {
                request.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement("/temp"));
                Part part = request.servletRequest().getPart("image");
                imageDao.upload(part);
                response.result("You have succesfully uploaded an image");
            }
            catch (Exception e) {
                response.status(401);
                response.result(e.getMessage());
            }
        });
        http.get(elepy.getBaseSlug() + "/images/gallery", (request, response) -> {
            ArrayList images = new ArrayList(imageDao.getAll());
            response.result(elepy.getObjectMapper().writeValueAsString(images));
        });
        http.get(elepy.getBaseSlug() + "/images/:id", (request, response) -> {
            Optional<GridFSDBFile> image = imageDao.getGridFile(request.params("id"));
            if (image.isPresent()) {
                response.type(image.get().getContentType());
                HttpServletResponse raw = response.servletResponse();
                raw.getOutputStream().write(IOUtils.toByteArray((InputStream)image.get().getInputStream()));
                raw.getOutputStream().flush();
                raw.getOutputStream().close();
            }
            response.status(404);
            response.result("");
        });
        http.delete(elepy.getBaseSlug() + "/images/:id", (request, response) -> {
            Optional image = imageDao.getById((Serializable)((Object)request.params("id")));
            if (image.isPresent()) {
                imageDao.deleteById((Serializable)((Object)request.params("id")));
                response.result("Successfully deleted image!");
            }
            response.status(404);
            response.result("Image not found");
        });
    }

    public String renderContent(Map<String, Object> map) {
        PebbleEngine engine = new PebbleEngine.Builder().build();
        try {
            PebbleTemplate images = engine.getTemplate("images.peb");
            StringWriter writer = new StringWriter();
            HashMap context = new HashMap();
            images.evaluate((Writer)writer, context);
            return ((Object)writer).toString();
        }
        catch (PebbleException | IOException e) {
            logger.error(e.getMessage(), e);
            return "<h1 class = \"uk-text-center uk-margin-top\" >Hey, I support plugins now!!!!!!!!!!!!!</h1>";
        }
    }
}

