/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.plugins.gallery;

import com.elepy.dao.jongo.DefaultMongoDao;
import com.elepy.plugins.gallery.Image;
import com.elepy.utils.StringUtils;
import com.github.slugify.Slugify;
import com.mongodb.DB;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.servlet.http.Part;
import org.imgscalr.Scalr;

public class ImageDao
extends DefaultMongoDao<Image> {
    private final DB db;

    ImageDao(DB db) {
        super(db, "images", Image.class);
        this.db = db;
    }

    void upload(Part part) throws IOException {
        String newFileName = String.format("%s-%s", StringUtils.getRandomHexString((int)5), new Slugify().slugify(part.getSubmittedFileName().split("\\.")[0]));
        GridFSInputFile originalGfs = new GridFS(this.db, "images").createFile(part.getInputStream());
        originalGfs.setFilename(newFileName + "-original");
        originalGfs.setContentType(part.getContentType());
        originalGfs.save();
        BufferedImage original = ImageIO.read(part.getInputStream());
        Dimension scale = this.scaleDown(original, new Dimension(250, 250));
        BufferedImage caption = Scalr.resize((BufferedImage)original, (int)scale.width, (int)scale.height, (BufferedImageOp[])new BufferedImageOp[0]);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)caption, "png", os);
        GridFSInputFile captionGfs = new GridFS(this.db, "images").createFile((InputStream)new ByteArrayInputStream(os.toByteArray()));
        captionGfs.setContentType("image/png");
        captionGfs.setFilename(newFileName + "-caption");
        captionGfs.save();
        Image image = new Image(newFileName);
        this.create(image);
    }

    private Dimension scaleDown(BufferedImage imgSize, Dimension boundary) {
        int originalWidth = imgSize.getWidth();
        int originalHeight = imgSize.getHeight();
        int boundWidth = boundary.width;
        int boundHeight = boundary.height;
        int newWidth = originalWidth;
        int newHeight = originalHeight;
        if (originalWidth > boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originalHeight / originalWidth;
        }
        if (newHeight > boundHeight) {
            newHeight = boundHeight;
            newWidth = newHeight * originalWidth / originalHeight;
        }
        return new Dimension(newWidth, newHeight);
    }

    public void deleteById(Serializable id) {
        super.deleteById(id);
        GridFS images = new GridFS(this.db, "images");
        images.remove(id + "-original");
        images.remove(id + "-caption");
    }

    public void create(Image item) {
        this.collection().insert((Object)item);
    }

    Optional<GridFSDBFile> getGridFile(String id) {
        return Optional.ofNullable(new GridFS(this.db, "images").findOne(id));
    }
}

