/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.vertx;

import com.elepy.http.Request;
import com.elepy.http.Session;
import com.elepy.uploads.FileUpload;
import com.elepy.vertx.VertxSession;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class VertxRequest
implements Request {
    private final HttpServerRequest request;
    private final RoutingContext routingContext;

    public VertxRequest(RoutingContext routingContext) {
        this.routingContext = routingContext;
        this.request = routingContext.request();
    }

    public String params(String param) {
        return this.routingContext.pathParam(param);
    }

    public String method() {
        return this.request.rawMethod();
    }

    public String scheme() {
        return this.request.scheme();
    }

    public String host() {
        return this.request.host();
    }

    public int port() {
        return this.request.remoteAddress().port();
    }

    public String url() {
        return this.request.absoluteURI();
    }

    public String ip() {
        return this.request.remoteAddress().host();
    }

    public String body() {
        return this.routingContext.getBodyAsString();
    }

    public byte[] bodyAsBytes() {
        return this.routingContext.getBody().getBytes();
    }

    public String queryParams(String queryParam) {
        return this.request.getParam(queryParam);
    }

    public String queryParamOrDefault(String queryParam, String defaultValue) {
        String param = this.queryParams(queryParam);
        return param == null ? defaultValue : param;
    }

    public String headers(String header) {
        return this.request.getHeader(header);
    }

    public <T> T attribute(String attribute) {
        return (T)this.routingContext.get(attribute);
    }

    public Map<String, String> cookies() {
        HashMap<String, String> cookies = new HashMap<String, String>();
        this.routingContext.cookies().forEach(cookie -> cookies.put(cookie.getName(), cookie.getValue()));
        return cookies;
    }

    public String cookie(String name) {
        return this.routingContext.cookies().stream().filter(cookie -> cookie.getName().equals(name)).findFirst().map(Cookie::getValue).orElse(null);
    }

    public String uri() {
        return this.request.uri();
    }

    public Session session() {
        return new VertxSession(this.routingContext);
    }

    public Set<String> queryParams() {
        return this.request.params().names();
    }

    public Set<String> headers() {
        return this.request.headers().names();
    }

    public String queryString() {
        return this.request.query();
    }

    public Map<String, String> params() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        this.request.params().forEach(entry -> toReturn.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue()));
        return toReturn;
    }

    public String[] queryParamValues(String key) {
        return this.request.params().getAll(key).toArray(new String[0]);
    }

    public List<FileUpload> uploadedFiles(String key) {
        return this.routingContext.fileUploads().stream().filter(file -> file.name().equals(key)).map(file -> {
            try {
                return FileUpload.of((String)file.fileName(), (String)file.contentType(), (InputStream)new BufferedInputStream(new FileInputStream(new File(file.uploadedFileName()))), (long)file.size());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void attribute(String attribute, Object value) {
        this.routingContext.put(attribute, value);
    }

    public Set<String> attributes() {
        return this.routingContext.data().keySet();
    }
}

