/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.vertx;

import com.elepy.http.Response;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.CookieImpl;

public class VertxResponse
implements Response {
    static final String RESPONSE_KEY = "response";
    private final RoutingContext routingContext;
    private final HttpServerResponse response;

    public VertxResponse(RoutingContext routingContext) {
        this.routingContext = routingContext;
        this.response = routingContext.response();
        this.response.putHeader("Content-Type", "text/html");
    }

    public void status(int statusCode) {
        this.response.setStatusCode(statusCode);
    }

    public int status() {
        return this.response.getStatusCode();
    }

    public void result(String body) {
        this.put(this.routingContext, RESPONSE_KEY, body);
    }

    public void result(byte[] bytes) {
        this.put(this.routingContext, RESPONSE_KEY, bytes);
    }

    public String result() {
        return (String)this.routingContext.get(RESPONSE_KEY);
    }

    public void type(String type) {
        this.response.putHeader("Content-Type", type);
    }

    public String type() {
        return this.response.headers().get("Content-Type");
    }

    public void removeCookie(String name) {
        this.routingContext.cookies().removeIf(cookie -> cookie.getName().equals(name));
    }

    public void cookie(String name, String value) {
        this.routingContext.cookies().add(new CookieImpl(name, value));
    }

    public void cookie(String name, String value, int maxAge) {
        CookieImpl cookie = new CookieImpl(name, value);
        cookie.setMaxAge((long)maxAge);
        this.routingContext.cookies().add(cookie);
        this.routingContext.addCookie((Cookie)cookie);
        this.routingContext.response().setChunked(true);
        this.routingContext.response().putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)"*");
        this.routingContext.response().putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)"*");
    }

    private void put(RoutingContext routingContext, String k, Object v) {
        routingContext.remove(k);
        routingContext.put(k, v);
    }

    public void redirect(String location, int httpStatusCode) {
        this.header("Location", location);
        this.status(httpStatusCode);
    }

    public void header(String s, String s1) {
        this.response.putHeader(s, s1);
    }
}

