/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.vertx;

import com.elepy.exceptions.ElepyConfigException;
import com.elepy.exceptions.ElepyException;
import com.elepy.exceptions.HaltException;
import com.elepy.http.ExceptionHandler;
import com.elepy.http.HttpContext;
import com.elepy.http.HttpContextHandler;
import com.elepy.http.HttpService;
import com.elepy.http.Route;
import com.elepy.http.StaticFileLocation;
import com.elepy.vertx.VertxContext;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.StaticHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.util.MultiMap;

public class VertxService
implements HttpService {
    private final HttpServer server;
    private final Vertx vertx = Vertx.vertx();
    private final Router router;
    private int port = 1337;
    private Map<RouteKey, Route> routes;
    private int counter;
    private boolean ignitedOnce = false;
    private StaticHandler staticHandler = null;
    private Map<Class, ExceptionHandler> exceptionHandlers;
    private MultiMap<HttpContextHandler> before;
    private MultiMap<HttpContextHandler> after;

    public VertxService() {
        this.server = this.vertx.createHttpServer();
        this.router = Router.router((Vertx)this.vertx);
        this.exceptionHandlers = new HashMap<Class, ExceptionHandler>();
        this.exceptionHandlers.put(Exception.class, (e, ctx) -> e.printStackTrace());
        this.before = new MultiMap();
        this.after = new MultiMap();
        this.routes = new HashMap<RouteKey, Route>();
    }

    public void port(int port) {
        this.port = port;
    }

    public int port() {
        return this.port;
    }

    public void stop() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.vertx.close(voidAsyncResult -> countDownLatch.countDown());
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void staticFiles(String path, StaticFileLocation location) {
        this.staticHandler = StaticHandler.create().setWebRoot(path);
    }

    public <T extends Exception> void exception(Class<T> exceptionClass, ExceptionHandler<? super T> handler) {
        this.exceptionHandlers.put(exceptionClass, handler);
    }

    public void before(HttpContextHandler contextHandler) {
        this.before.put(null, (Object)contextHandler);
    }

    public void before(String path, HttpContextHandler contextHandler) {
        this.before.put(path, (Object)contextHandler);
    }

    public void after(String path, HttpContextHandler contextHandler) {
        this.after.put(path, (Object)contextHandler);
    }

    public void after(HttpContextHandler contextHandler) {
        this.after.put(null, (Object)contextHandler);
    }

    public void addRoute(Route route) {
        if (this.ignitedOnce) {
            throw new ElepyConfigException("Can't add routes after server has ignited");
        }
        this.routes.put(new RouteKey(this.counter++), route);
    }

    public void ignite() {
        this.router.route().handler((Handler)BodyHandler.create().setMergeFormAttributes(true).setUploadsDirectory(System.getProperty("java.io.tmpdir")));
        this.router.route().handler((Handler)CookieHandler.create());
        this.igniteBefore();
        this.igniteRoutes();
        this.igniteAfter();
        this.igniteStatic();
        this.igniteFinal();
        this.ignitedOnce = true;
        this.server.requestHandler((Handler)this.router);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.server.listen(this.port, httpServerAsyncResult -> countDownLatch.countDown());
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void igniteStatic() {
        if (this.staticHandler != null) {
            this.router.route().handler((Handler)this.staticHandler);
        }
    }

    private void igniteFinal() {
        this.router.route().handler(this::endRoute);
    }

    private void igniteAfter() {
        this.igniteMultiMapContexts(this.after);
    }

    private void igniteBefore() {
        this.igniteMultiMapContexts(this.before);
    }

    private Handler<RoutingContext> handleSafely(Handler<RoutingContext> h) {
        return routingContext -> {
            try {
                h.handle(routingContext);
            }
            catch (Exception e) {
                ExceptionHandler exceptionHandler = this.getExceptionHandler(e.getClass());
                if (exceptionHandler != null) {
                    exceptionHandler.handleException(e, (HttpContext)new VertxContext((RoutingContext)routingContext));
                }
                this.endRoute((RoutingContext)routingContext);
            }
        };
    }

    private void endRoute(RoutingContext routingContext) {
        Object responseBody = routingContext.get("response");
        if (responseBody == null) {
            routingContext.response().end("<h2>404 Not Found</h2>");
        } else if (responseBody instanceof byte[]) {
            routingContext.response().end(Buffer.buffer((byte[])((byte[])responseBody)));
        } else {
            routingContext.response().end(responseBody.toString());
        }
    }

    private void igniteMultiMapContexts(MultiMap<HttpContextHandler> contexts) {
        contexts.forEach((path, contextHandlers) -> Optional.ofNullable(path).map(arg_0 -> ((Router)this.router).route(arg_0)).orElse(this.router.route()).handler(this.handleSafely((Handler<RoutingContext>)((Handler)routingContext -> contextHandlers.forEach(contextHandler -> {
            try {
                contextHandler.handle((HttpContext)new VertxContext((RoutingContext)routingContext));
            }
            catch (HaltException e) {
                this.endRoute((RoutingContext)routingContext);
            }
            catch (ElepyException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ElepyException(e.getMessage(), 500, (Throwable)e);
            }
            routingContext.next();
        })))));
    }

    private void igniteRoutes() {
        this.routes.forEach((key, route) -> {
            if (!key.ignited) {
                key.ignited = true;
                this.igniteRoute((Route)route);
            }
        });
    }

    public ExceptionHandler getExceptionHandler(Class<? extends Exception> exceptionClass) {
        if (!this.exceptionHandlers.containsKey(exceptionClass)) {
            Class<? extends Exception> superclass = exceptionClass.getSuperclass();
            do {
                if (!this.exceptionHandlers.containsKey(superclass)) continue;
                ExceptionHandler handler = this.exceptionHandlers.get(superclass);
                this.exceptionHandlers.put(exceptionClass, handler);
                return handler;
            } while ((superclass = superclass.getSuperclass()) != null);
            this.exceptionHandlers.put(exceptionClass, null);
            return null;
        }
        return this.exceptionHandlers.get(exceptionClass);
    }

    private void igniteRoute(Route extraRoute) {
        this.router.route(this.transformToHttpMethod(extraRoute), extraRoute.getPath()).handler(this.handleSafely((Handler<RoutingContext>)((Handler)routingContext -> {
            VertxContext vertxContext = new VertxContext((RoutingContext)routingContext);
            extraRoute.getHttpContextHandler().handleWithExceptions((HttpContext)vertxContext);
            routingContext.next();
        })));
    }

    private HttpMethod transformToHttpMethod(Route route) {
        return HttpMethod.valueOf((String)route.getMethod().name());
    }

    private class RouteKey
    implements Comparable<RouteKey> {
        private final Integer id;
        private boolean ignited;

        private RouteKey(Integer id) {
            this.id = id;
            this.ignited = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteKey routeKey = (RouteKey)o;
            return Objects.equals(this.id, routeKey.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        @Override
        public int compareTo(RouteKey o) {
            return this.id.compareTo(o.id);
        }
    }
}

