/*
 * Decompiled with CFR 0.152.
 */
package de.slikey.effectlib.math;

import de.slikey.effectlib.math.Transform;
import de.slikey.effectlib.math.Transforms;
import de.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class VectorTransform {
    private final Transform xTransform;
    private final Transform yTransform;
    private final Transform zTransform;
    private final boolean orient;

    public VectorTransform(ConfigurationSection configuration) {
        this.xTransform = Transforms.loadTransform(configuration, "x");
        this.yTransform = Transforms.loadTransform(configuration, "y");
        this.zTransform = Transforms.loadTransform(configuration, "z");
        this.orient = configuration.getBoolean("orient", true);
    }

    public Vector get(Location source, double t) {
        double xValue = this.xTransform.get(t);
        double yValue = this.yTransform.get(t);
        double zValue = this.zTransform.get(t);
        Vector result = new Vector(xValue, yValue, zValue);
        if (this.orient && source != null) {
            result = VectorUtils.rotateVector(result, source);
        }
        return result;
    }
}

