/*
 * Decompiled with CFR 0.152.
 */
package com.elsevier.spark_xml_utils.xpath;

import com.elsevier.spark_xml_utils.xpath.XPathException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathProcessor
implements Serializable {
    private static final long serialVersionUID = 7211034934310706719L;
    private static Log log = LogFactory.getLog(XPathProcessor.class);
    private String xPathExpression = null;
    private HashMap<String, String> namespaceMappings = null;
    private HashMap<String, Object> featureMappings = null;
    private transient XPathSelector xsel = null;
    private transient DocumentBuilder builder = null;
    private transient Processor proc = null;
    private transient Serializer serializer = null;
    private transient ByteArrayOutputStream baos = null;

    private XPathProcessor(String xPathExpression, HashMap<String, String> namespaceMappings, HashMap<String, Object> featureMappings) throws XPathException {
        this.xPathExpression = xPathExpression;
        this.namespaceMappings = namespaceMappings;
        this.featureMappings = featureMappings;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException, XPathException {
        inputStream.defaultReadObject();
        this.init();
    }

    public static XPathProcessor getInstance(String xPathExpression) throws XPathException {
        XPathProcessor proc = new XPathProcessor(xPathExpression, null, null);
        proc.init();
        return proc;
    }

    public static XPathProcessor getInstance(String xPathExpression, HashMap<String, String> namespaceMappings) throws XPathException {
        XPathProcessor proc = new XPathProcessor(xPathExpression, namespaceMappings, null);
        proc.init();
        return proc;
    }

    public static XPathProcessor getInstance(String xPathExpression, HashMap<String, String> namespaceMappings, HashMap<String, Object> featureMappings) throws XPathException {
        XPathProcessor proc = new XPathProcessor(xPathExpression, namespaceMappings, featureMappings);
        proc.init();
        return proc;
    }

    private void init() throws XPathException {
        try {
            this.proc = new Processor(false);
            if (this.featureMappings != null) {
                for (Map.Entry<String, Object> entry : this.featureMappings.entrySet()) {
                    this.proc.setConfigurationProperty(entry.getKey(), entry.getValue());
                }
            }
            XPathCompiler xpathCompiler = this.proc.newXPathCompiler();
            this.setPrefixNamespaceMappings(xpathCompiler, this.namespaceMappings);
            this.xsel = xpathCompiler.compile(this.xPathExpression).load();
            this.builder = this.proc.newDocumentBuilder();
            this.baos = new ByteArrayOutputStream();
            this.serializer = this.proc.newSerializer((OutputStream)this.baos);
            this.serializer.setOutputStream((OutputStream)this.baos);
            this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            this.serializer.setProcessor(this.proc);
        }
        catch (SaxonApiException e) {
            log.error((Object)("Problems creating an XPathProcessor.  " + e.getMessage()), (Throwable)e);
            throw new XPathException(e.getMessage());
        }
    }

    public void setOutputMethod(String method) {
        this.serializer.setOutputProperty(Serializer.Property.METHOD, method);
    }

    public boolean filter(String content) throws XPathException {
        return this.filterString(content);
    }

    public boolean filterString(String content) throws XPathException {
        try {
            return this.filterStream(IOUtils.toInputStream((String)content, (String)"UTF-8"));
        }
        catch (IOException e) {
            log.error((Object)("Problems processing the content.  " + e.getMessage()), (Throwable)e);
            throw new XPathException(e.getMessage());
        }
    }

    public boolean filter(InputStream content) throws XPathException {
        return this.filterStream(content);
    }

    public boolean filterStream(InputStream content) throws XPathException {
        return this.filter(new StreamSource(content));
    }

    public String evaluate(String content) throws XPathException {
        return this.evaluateString(content);
    }

    public String evaluateString(String content) throws XPathException {
        try {
            return this.evaluateStream(IOUtils.toInputStream((String)content, (String)"UTF-8"));
        }
        catch (IOException e) {
            log.error((Object)("Problems processing the content.  " + e.getMessage()), (Throwable)e);
            throw new XPathException(e.getMessage());
        }
    }

    public String evaluate(InputStream content) throws XPathException {
        return this.evaluateStream(content);
    }

    public String evaluateStream(InputStream content) throws XPathException {
        return this.evaluate(new StreamSource(content));
    }

    private boolean filter(StreamSource content) throws XPathException {
        try {
            XdmNode xmlDoc = this.builder.build((Source)content);
            this.xsel.setContextItem((XdmItem)xmlDoc);
            return this.xsel.effectiveBooleanValue();
        }
        catch (SaxonApiException e) {
            log.error((Object)("Problems processing the content.  EXPRESSION:" + this.xPathExpression + " " + e.getMessage()), (Throwable)e);
            throw new XPathException(e.getMessage());
        }
    }

    private String evaluate(StreamSource content) throws XPathException {
        try {
            this.serializer.close();
            this.baos.reset();
            XdmNode xmlDoc = this.builder.build((Source)content);
            this.xsel.setContextItem((XdmItem)xmlDoc);
            XdmValue results = this.xsel.evaluate();
            for (XdmItem item : results) {
                this.serializer.serializeXdmValue((XdmValue)item);
            }
            return new String(this.baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            log.error((Object)("Problems processing the content.  EXPRESSION:" + this.xPathExpression + " " + e.getMessage()), (Throwable)e);
            throw new XPathException(e.getMessage());
        }
        catch (SaxonApiException e) {
            log.error((Object)("Problems processing the content.  EXPRESSION:" + this.xPathExpression + " " + e.getMessage()), (Throwable)e);
            throw new XPathException(e.getMessage());
        }
    }

    private void setPrefixNamespaceMappings(XPathCompiler xpathCompiler, HashMap<String, String> namespaceMappings) {
        Set<Map.Entry<String, String>> mappings;
        if (namespaceMappings != null && (mappings = namespaceMappings.entrySet()) != null) {
            for (Map.Entry<String, String> entry : mappings) {
                xpathCompiler.declareNamespace(entry.getKey(), entry.getValue());
            }
        }
        xpathCompiler.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        xpathCompiler.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        xpathCompiler.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
    }
}

