/*
 * Decompiled with CFR 0.152.
 */
package com.elsevier.spark_xml_utils.xquery;

import com.elsevier.spark_xml_utils.xquery.XQueryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryProcessor
implements Serializable {
    private static final long serialVersionUID = 4059250550297763372L;
    private static Log log = LogFactory.getLog(XQueryProcessor.class);
    private String xQueryExpression = null;
    private HashMap<String, String> namespaceMappings = null;
    private HashMap<String, Object> featureMappings = null;
    private transient Processor proc = null;
    private transient XQueryExecutable exp = null;
    private transient XQueryEvaluator eval = null;
    private transient Serializer serializer = null;
    private transient ByteArrayOutputStream baos = null;

    private XQueryProcessor(String xQueryExpression, HashMap<String, String> namespaceMappings, HashMap<String, Object> featureMappings) throws XQueryException {
        this.xQueryExpression = xQueryExpression;
        this.namespaceMappings = namespaceMappings;
        this.featureMappings = featureMappings;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException, XQueryException {
        inputStream.defaultReadObject();
        this.init();
    }

    public static XQueryProcessor getInstance(String xQueryExpression) throws XQueryException {
        XQueryProcessor proc = new XQueryProcessor(xQueryExpression, null, null);
        proc.init();
        return proc;
    }

    public static XQueryProcessor getInstance(String xQueryExpression, HashMap<String, String> namespaceMappings) throws XQueryException {
        XQueryProcessor proc = new XQueryProcessor(xQueryExpression, namespaceMappings, null);
        proc.init();
        return proc;
    }

    public static XQueryProcessor getInstance(String xQueryExpression, HashMap<String, String> namespaceMappings, HashMap<String, Object> featureMappings) throws XQueryException {
        XQueryProcessor proc = new XQueryProcessor(xQueryExpression, namespaceMappings, featureMappings);
        proc.init();
        return proc;
    }

    private void init() throws XQueryException {
        try {
            this.proc = new Processor(false);
            if (this.featureMappings != null) {
                for (Map.Entry<String, Object> entry : this.featureMappings.entrySet()) {
                    this.proc.setConfigurationProperty(entry.getKey(), entry.getValue());
                }
            }
            XQueryCompiler xqueryCompiler = this.proc.newXQueryCompiler();
            xqueryCompiler.setEncoding("UTF-8");
            this.setPrefixNamespaceMappings(xqueryCompiler, this.namespaceMappings);
            this.exp = xqueryCompiler.compile(this.xQueryExpression);
            this.eval = this.exp.load();
            this.baos = new ByteArrayOutputStream();
            this.serializer = this.proc.newSerializer((OutputStream)this.baos);
            this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            this.serializer.setProcessor(this.proc);
        }
        catch (SaxonApiException e) {
            log.error((Object)("Problems creating an XQueryProcessor.  " + e.getMessage()), (Throwable)e);
            throw new XQueryException(e.getMessage());
        }
    }

    public void setOutputMethod(String method) {
        this.serializer.setOutputProperty(Serializer.Property.METHOD, method);
    }

    public void setExternalVariable(String name, String value) {
        this.eval.setExternalVariable(new QName(name), (XdmValue)new XdmAtomicValue(value));
    }

    public String evaluate(String content) throws XQueryException {
        return this.evaluateString(content);
    }

    public String evaluateString(String content) throws XQueryException {
        try {
            return this.evaluateStream(IOUtils.toInputStream((String)content, (String)"UTF-8"));
        }
        catch (IOException e) {
            log.error((Object)("Problems processing the content.  " + e.getMessage()), (Throwable)e);
            throw new XQueryException(e.getMessage());
        }
    }

    public String evaluate(InputStream content) throws XQueryException {
        return this.evaluateStream(content);
    }

    public String evaluateStream(InputStream content) throws XQueryException {
        return this.evaluate(new StreamSource(content));
    }

    private String evaluate(StreamSource content) throws XQueryException {
        try {
            this.serializer.close();
            this.baos.reset();
            this.eval.setSource((Source)content);
            this.eval.run((Destination)this.serializer);
            return new String(this.baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            log.error((Object)("Problems processing the content.  EXPRESSION:" + this.xQueryExpression + " " + e.getMessage()), (Throwable)e);
            throw new XQueryException(e.getMessage());
        }
        catch (SaxonApiException e) {
            log.error((Object)("Problems processing the content.  EXPRESSION:" + this.xQueryExpression + " " + e.getMessage()), (Throwable)e);
            throw new XQueryException(e.getMessage());
        }
    }

    private void setPrefixNamespaceMappings(XQueryCompiler xqueryCompiler, HashMap<String, String> namespaceMappings) {
        Set<Map.Entry<String, String>> mappings;
        if (namespaceMappings != null && (mappings = namespaceMappings.entrySet()) != null) {
            for (Map.Entry<String, String> entry : mappings) {
                xqueryCompiler.declareNamespace(entry.getKey(), entry.getValue());
            }
        }
        xqueryCompiler.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        xqueryCompiler.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        xqueryCompiler.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
    }
}

