/*
 * Decompiled with CFR 0.152.
 */
package com.elsevier.spark_xml_utils.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3URIResolver
implements URIResolver {
    private HashMap<String, String> stylesheetMap = new HashMap();
    private static Log log = LogFactory.getLog(S3URIResolver.class);

    public Source resolve(String href, String base) throws TransformerException {
        try {
            if (this.stylesheetMap.containsKey(href)) {
                return new StreamSource(IOUtils.toInputStream((String)this.stylesheetMap.get(href)));
            }
            URL theUrl = new URL(href);
            this.stylesheetMap.put(href, IOUtils.toString((InputStream)theUrl.openStream()));
            return new StreamSource(IOUtils.toInputStream((String)this.stylesheetMap.get(href)));
        }
        catch (IOException e) {
            log.error((Object)("Problems resolving a stylesheet. URI:" + href + " " + e.getMessage()), (Throwable)e);
            throw new TransformerException(e.getMessage());
        }
    }
}

