/*
 * Decompiled with CFR 0.152.
 */
package com.elsevier.spark_xml_utils.xslt;

import com.elsevier.spark_xml_utils.xslt.S3URIResolver;
import com.elsevier.spark_xml_utils.xslt.XSLTException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTProcessor
implements Serializable {
    private static final long serialVersionUID = -5320116690116312347L;
    private static Log log = LogFactory.getLog(XSLTProcessor.class);
    private HashMap<String, Object> featureMappings = null;
    private String stylesheet = null;
    private transient Processor proc = null;
    private transient Serializer serializer = null;
    private transient ByteArrayOutputStream baos = null;
    private transient XsltTransformer trans = null;
    private transient DocumentBuilder builder = null;

    private XSLTProcessor(String stylesheet, HashMap<String, Object> featureMappings) throws XSLTException {
        this.stylesheet = stylesheet;
        this.featureMappings = featureMappings;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException, XSLTException {
        inputStream.defaultReadObject();
        this.init();
    }

    public static XSLTProcessor getInstance(String stylesheet) throws XSLTException {
        XSLTProcessor proc = new XSLTProcessor(stylesheet, null);
        proc.init();
        return proc;
    }

    public static XSLTProcessor getInstance(String stylesheet, HashMap<String, Object> featureMappings) throws XSLTException {
        XSLTProcessor proc = new XSLTProcessor(stylesheet, featureMappings);
        proc.init();
        return proc;
    }

    private void init() throws XSLTException {
        try {
            this.proc = new Processor(false);
            if (this.featureMappings != null) {
                for (Map.Entry<String, Object> entry : this.featureMappings.entrySet()) {
                    this.proc.setConfigurationProperty(entry.getKey(), entry.getValue());
                }
            }
            XsltCompiler xsltCompiler = this.proc.newXsltCompiler();
            this.builder = this.proc.newDocumentBuilder();
            xsltCompiler.setURIResolver((URIResolver)new S3URIResolver());
            XsltExecutable exp = xsltCompiler.compile((Source)new StreamSource(IOUtils.toInputStream((String)this.stylesheet, (String)"UTF-8")));
            this.baos = new ByteArrayOutputStream();
            this.serializer = this.proc.newSerializer((OutputStream)this.baos);
            this.serializer.setOutputStream((OutputStream)this.baos);
            this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            this.serializer.setProcessor(this.proc);
            this.trans = exp.load();
            this.trans.setDestination((Destination)this.serializer);
        }
        catch (SaxonApiException e) {
            log.error((Object)("Problems creating an XSLTProcessor.  " + e.getMessage()), (Throwable)e);
            throw new XSLTException(e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)("Problems creating an XSLTProcessor.  " + e.getMessage()), (Throwable)e);
            throw new XSLTException(e.getMessage());
        }
    }

    public void setOutputMethod(String method) {
        this.serializer.setOutputProperty(Serializer.Property.METHOD, method);
    }

    public String transform(String content) throws XSLTException {
        return this.transform(content, new HashMap<String, String>());
    }

    public String transform(InputStream content) throws XSLTException {
        return this.transform(new StreamSource(content), new HashMap<String, String>());
    }

    public String transform(String content, HashMap<String, String> stylesheetParams) throws XSLTException {
        try {
            StreamSource contentSource = new StreamSource(IOUtils.toInputStream((String)content, (String)"UTF-8"));
            return this.transform(contentSource, stylesheetParams);
        }
        catch (IOException e) {
            log.error((Object)("Problems transforming the content. " + e.getMessage()), (Throwable)e);
            throw new XSLTException(e.getMessage());
        }
    }

    private String transform(StreamSource content, HashMap<String, String> stylesheetParams) throws XSLTException {
        try {
            this.serializer.close();
            this.baos.reset();
            for (Map.Entry<String, String> entry : stylesheetParams.entrySet()) {
                XdmNode xdmValue = this.builder.build((Source)new StreamSource(IOUtils.toInputStream((String)entry.getValue(), (String)"UTF-8")));
                this.trans.setParameter(new QName("", entry.getKey()), (XdmValue)xdmValue);
            }
            this.trans.setSource((Source)content);
            this.trans.transform();
            return new String(this.baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            log.error((Object)("Problems transforming the content.  " + e.getMessage()), (Throwable)e);
            throw new XSLTException(e.getMessage());
        }
        catch (SaxonApiException e) {
            log.error((Object)("Problems transforming the content.  " + e.getMessage()), (Throwable)e);
            throw new XSLTException(e.getMessage());
        }
    }
}

