/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

import com.elvishew.xlog.formatter.DefaultFormatterFactory;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.method.MethodFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;

public class LogConfiguration {
    public final String tag;
    public final JsonFormatter jsonFormatter;
    public final XmlFormatter xmlFormatter;
    public final MethodFormatter methodFormatter;
    public final ThrowableFormatter throwableFormatter;

    LogConfiguration(Builder builder) {
        this.tag = builder.tag;
        this.jsonFormatter = builder.jsonFormatter;
        this.xmlFormatter = builder.xmlFormatter;
        this.methodFormatter = builder.methodFormatter;
        this.throwableFormatter = builder.throwableFormatter;
    }

    public static class Builder {
        private static final String DEFAULT_TAG = "XLog";
        private String tag = "XLog";
        private JsonFormatter jsonFormatter;
        private XmlFormatter xmlFormatter;
        private MethodFormatter methodFormatter;
        private ThrowableFormatter throwableFormatter;

        public Builder() {
        }

        public Builder(LogConfiguration logConfiguration) {
            this.tag = logConfiguration.tag;
            this.jsonFormatter = logConfiguration.jsonFormatter;
            this.xmlFormatter = logConfiguration.xmlFormatter;
            this.methodFormatter = logConfiguration.methodFormatter;
            this.throwableFormatter = logConfiguration.throwableFormatter;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder jsonFormatter(JsonFormatter jsonFormatter) {
            this.jsonFormatter = jsonFormatter;
            return this;
        }

        public Builder xmlFormatter(XmlFormatter xmlFormatter) {
            this.xmlFormatter = xmlFormatter;
            return this;
        }

        public Builder methodFormatter(MethodFormatter methodFormatter) {
            this.methodFormatter = methodFormatter;
            return this;
        }

        public Builder throwableFormatter(ThrowableFormatter throwableFormatter) {
            this.throwableFormatter = throwableFormatter;
            return this;
        }

        public LogConfiguration build() {
            this.initEmptyFieldsWithDefaultValues();
            return new LogConfiguration(this);
        }

        private void initEmptyFieldsWithDefaultValues() {
            if (this.jsonFormatter == null) {
                this.jsonFormatter = DefaultFormatterFactory.createJsonFormatter();
            }
            if (this.xmlFormatter == null) {
                this.xmlFormatter = DefaultFormatterFactory.createXmlFormatter();
            }
            if (this.methodFormatter == null) {
                this.methodFormatter = DefaultFormatterFactory.createMethodFormatter();
            }
            if (this.throwableFormatter == null) {
                this.throwableFormatter = DefaultFormatterFactory.createThrowableFormatter();
            }
        }
    }
}

