/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.Logger;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.method.MethodFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.printer.AndroidPrinter;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.util.StackTraceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XLog {
    static LogConfiguration sLogConfiguration;
    static List<Printer> sPrinters;
    static int sLogLevel;
    private static ThreadLocal<Logger> sLocalLogger;
    private static boolean sIsInitialized;

    private XLog() {
    }

    public static void init(int logLevel) {
        XLog.init(logLevel, new LogConfiguration.Builder().build(), new AndroidPrinter());
    }

    public static void init(int logLevel, LogConfiguration logConfiguration) {
        XLog.init(logLevel, logConfiguration, new AndroidPrinter());
    }

    public static void init(int logLevel, Printer ... printers) {
        XLog.init(logLevel, new LogConfiguration.Builder().build(), printers);
    }

    public static void init(int logLevel, LogConfiguration logConfiguration, Printer ... printers) {
        if (sIsInitialized) {
            throw new IllegalStateException("XLog is already initialized, do not initialize again.");
        }
        sLogLevel = logLevel;
        sLogConfiguration = logConfiguration;
        sPrinters.addAll(Arrays.asList(printers));
    }

    public static Logger.Builder tag(String tag) {
        return new Logger.Builder().tag(tag);
    }

    public static Logger.Builder jsonFormatter(JsonFormatter jsonFormatter) {
        return new Logger.Builder().jsonFormatter(jsonFormatter);
    }

    public static Logger.Builder xmlFormatter(XmlFormatter xmlFormatter) {
        return new Logger.Builder().xmlFormatter(xmlFormatter);
    }

    public static Logger.Builder methodFormatter(MethodFormatter methodFormatter) {
        return new Logger.Builder().methodFormatter(methodFormatter);
    }

    public static Logger.Builder throwableFormatter(ThrowableFormatter throwableFormatter) {
        return new Logger.Builder().throwableFormatter(throwableFormatter);
    }

    public static Logger.Builder printers(Printer ... printers) {
        return new Logger.Builder().printers(printers);
    }

    public static void v(String format, Object ... args) {
        XLog.getLogger().v(format, args);
    }

    public static void v(String msg) {
        XLog.getLogger().v(msg);
    }

    public static void v(String msg, Throwable tr) {
        XLog.getLogger().v(msg, tr);
    }

    public static void d(String format, Object ... args) {
        XLog.getLogger().d(format, args);
    }

    public static void d(String msg) {
        XLog.getLogger().d(msg);
    }

    public static void d(String msg, Throwable tr) {
        XLog.getLogger().d(msg, tr);
    }

    public static void i(String format, Object ... args) {
        XLog.getLogger().i(format, args);
    }

    public static void i(String msg) {
        XLog.getLogger().i(msg);
    }

    public static void i(String msg, Throwable tr) {
        XLog.getLogger().i(msg, tr);
    }

    public static void w(String format, Object ... args) {
        XLog.getLogger().w(format, args);
    }

    public static void w(String msg) {
        XLog.getLogger().w(msg);
    }

    public static void w(String msg, Throwable tr) {
        XLog.getLogger().w(msg, tr);
    }

    public static void e(String format, Object ... args) {
        XLog.getLogger().e(format, args);
    }

    public static void e(String msg) {
        XLog.getLogger().e(msg);
    }

    public static void e(String msg, Throwable tr) {
        XLog.getLogger().e(msg, tr);
    }

    public static void json(String json) {
        XLog.getLogger().json(json);
    }

    public static void xml(String xml) {
        XLog.getLogger().xml(xml);
    }

    public static void method(Object ... arguments) {
        XLog.getLogger().method(1, arguments);
    }

    public static void stack() {
        XLog.getLogger().stack("", 1);
    }

    public static void stack(String format, Object ... args) {
        XLog.getLogger().stack(String.format(format, args), 1);
    }

    public static void stack(String msg) {
        XLog.getLogger().stack(msg, 1);
    }

    private static Logger getLogger() {
        return sLocalLogger.get();
    }

    static {
        sPrinters = new ArrayList<Printer>();
        sLogLevel = 2;
        sLocalLogger = new ThreadLocal<Logger>(){

            @Override
            protected Logger initialValue() {
                return new Logger(sLogConfiguration, sPrinters);
            }
        };
    }

    public static class Log {
        public static void v(String tag, String msg) {
            XLog.tag(tag).build().v(msg);
        }

        public static void v(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().v(msg, tr);
        }

        public static void d(String tag, String msg) {
            XLog.tag(tag).build().d(msg);
        }

        public static void d(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().d(msg, tr);
        }

        public static void i(String tag, String msg) {
            XLog.tag(tag).build().i(msg);
        }

        public static void i(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().i(msg, tr);
        }

        public static void w(String tag, String msg) {
            XLog.tag(tag).build().w(msg);
        }

        public static void w(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().w(msg, tr);
        }

        public static void w(String tag, Throwable tr) {
            XLog.tag(tag).build().w("", tr);
        }

        public static void e(String tag, String msg) {
            XLog.tag(tag).build().e(msg);
        }

        public static void e(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().e(msg, tr);
        }

        public static void wtf(String tag, String msg) {
            Log.e(tag, msg);
        }

        public static void wtf(String tag, Throwable tr) {
            Log.wtf(tag, "", tr);
        }

        public static void wtf(String tag, String msg, Throwable tr) {
            Log.e(tag, msg, tr);
        }

        public static void println(int logLevel, String tag, String msg) {
            XLog.tag(tag).build().println(logLevel, msg);
        }

        public static boolean isLoggable(String tag, int level) {
            return level >= sLogLevel;
        }

        public static String getStackTraceString(Throwable tr) {
            return StackTraceUtil.getStackTraceString(tr);
        }
    }
}

