/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.formatter.message.method;

import com.elvishew.xlog.formatter.message.method.MethodFormatter;
import com.elvishew.xlog.formatter.message.method.MethodInfo;

public class DefaultMethodFormatter
implements MethodFormatter {
    @Override
    public String format(MethodInfo data) {
        StringBuilder sb = new StringBuilder(80);
        StackTraceElement callSource = data.stackTraceElements[0];
        sb.append(this.getSimpleClassName(callSource.getClassName())).append(".").append(callSource.getMethodName()).append(" (").append(callSource.getFileName()).append(":").append(callSource.getLineNumber()).append(") ");
        int paramCount = data.arguments.length;
        if (paramCount != 0) {
            sb.append('(');
            if (paramCount == 1) {
                sb.append(data.arguments[0]);
            } else if (paramCount > 1) {
                sb.append(data.arguments[0]);
                for (int i = 1; i < paramCount; ++i) {
                    sb.append(", ").append(data.arguments[i]);
                }
            }
            sb.append(')');
        }
        return sb.toString();
    }

    private String getSimpleClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return name.substring(lastIndex + 1);
    }
}

