/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.printer;

import com.elvishew.xlog.System;
import com.elvishew.xlog.border.BorderConfiguration;
import com.elvishew.xlog.printer.MessageFormattedPrinter;

public abstract class MessageBorderedPrinter
extends MessageFormattedPrinter {
    private final BorderConfiguration borderConfiguration;

    public MessageBorderedPrinter(BorderConfiguration borderConfiguration) {
        this.borderConfiguration = borderConfiguration;
    }

    @Override
    protected final void onPrintFormattedMessage(int logLevel, String tag, String msg) {
        this.onPrintBorderedMessage(logLevel, tag, this.borderMsgIfNecessary(msg));
    }

    protected abstract void onPrintBorderedMessage(int var1, String var2, String var3);

    private String borderMsgIfNecessary(String msg) {
        if (this.borderConfiguration.isEnabled) {
            String[] lines;
            String topHorizontalBorder = null;
            String bottomHorizontalBorder = null;
            if (this.borderConfiguration.horizontalBorderChar == '\u2550' && this.borderConfiguration.verticalBorderChar == '\u2551') {
                if (this.borderConfiguration.borderLength == 100) {
                    topHorizontalBorder = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
                    bottomHorizontalBorder = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
                } else {
                    String horizontalBorder = this.buildHorizontalBorder(this.borderConfiguration.horizontalBorderChar, this.borderConfiguration.borderLength);
                    topHorizontalBorder = '\u2554' + horizontalBorder;
                    bottomHorizontalBorder = '\u255a' + horizontalBorder;
                }
            }
            if (topHorizontalBorder == null) {
                bottomHorizontalBorder = topHorizontalBorder = this.buildHorizontalBorder(this.borderConfiguration.horizontalBorderChar, this.borderConfiguration.borderLength);
            }
            StringBuilder msgWithVerticalBorderBuilder = new StringBuilder(msg.length() + 10);
            for (String line : lines = msg.split(System.lineSeparator)) {
                msgWithVerticalBorderBuilder.append(this.borderConfiguration.verticalBorderChar).append(line).append(System.lineSeparator);
            }
            String msgWithVerticalBorder = msgWithVerticalBorderBuilder.toString();
            StringBuilder messageBuilder = new StringBuilder(msgWithVerticalBorder.length() + 2 * (this.borderConfiguration.borderLength + 1));
            messageBuilder.append(topHorizontalBorder).append(System.lineSeparator).append(msgWithVerticalBorder).append(bottomHorizontalBorder);
            msg = messageBuilder.toString();
        }
        return msg;
    }

    private String buildHorizontalBorder(char horizontalBorderChar, int borderLength) {
        StringBuilder horizontalBorderBuilder = new StringBuilder(borderLength);
        for (int i = borderLength; i > 0; --i) {
            horizontalBorderBuilder.append(horizontalBorderChar);
        }
        return horizontalBorderBuilder.toString();
    }
}

