/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.printer.file;

import com.elvishew.xlog.formatter.DefaultFormatterFactory;
import com.elvishew.xlog.formatter.log.LogFormatter;
import com.elvishew.xlog.printer.MessageFormattedPrinter;
import com.elvishew.xlog.printer.file.backup.BackupStrategy;
import com.elvishew.xlog.printer.file.backup.FileSizeBackupStrategy;
import com.elvishew.xlog.printer.file.naming.ChangelessFileNameGenerator;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class FilePrinter
extends MessageFormattedPrinter {
    private final String folderPath;
    private final FileNameGenerator fileNameGenerator;
    private final BackupStrategy backupStrategy;
    private LogFormatter logFormatter;
    private BufferedWriter mBufferedWriter;
    private String lastFileName;
    private File logFile;

    FilePrinter(Builder builder) {
        this.folderPath = builder.folderPath;
        this.fileNameGenerator = builder.fileNameGenerator;
        this.backupStrategy = builder.backupStrategy;
        this.logFormatter = builder.logFormatter;
        this.checkLogFolder();
    }

    @Override
    protected void onPrintFormattedMessage(int logLevel, String tag, String msg) {
        long now = System.currentTimeMillis();
        if (this.lastFileName == null || this.fileNameGenerator.isFileNameChangeable()) {
            String newFileName = this.fileNameGenerator.generateFileName(logLevel, now);
            if (newFileName == null || newFileName.trim().length() == 0) {
                throw new IllegalArgumentException("File name should not be empty.");
            }
            if (!newFileName.equals(this.lastFileName)) {
                if (this.mBufferedWriter != null) {
                    this.closeLogWriter();
                }
                this.lastFileName = newFileName;
                this.openLogWriter();
            }
        }
        if (this.mBufferedWriter == null) {
            return;
        }
        if (this.backupStrategy.shouldBackup(this.logFile)) {
            this.closeLogWriter();
            File backupFile = new File(this.folderPath, this.lastFileName + ".bak");
            if (backupFile.exists()) {
                backupFile.delete();
            }
            this.logFile.renameTo(backupFile);
            this.openLogWriter();
            if (this.mBufferedWriter == null) {
                return;
            }
        }
        try {
            String formattedLog = this.logFormatter.format(logLevel, tag, msg, now);
            this.mBufferedWriter.write(formattedLog);
            this.mBufferedWriter.newLine();
            this.mBufferedWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkLogFolder() {
        File folder = new File(this.folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    private void openLogWriter() {
        this.logFile = new File(this.folderPath, this.lastFileName);
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.logFile, true);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            this.mBufferedWriter = new BufferedWriter(osw);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void closeLogWriter() {
        try {
            if (this.mBufferedWriter != null) {
                this.mBufferedWriter.close();
                this.mBufferedWriter = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        private static final String DEFAULT_LOG_FILE_NAME = "log";
        private static final long DEFAULT_LOG_FILE_MAX_SIZE = 0x100000L;
        String folderPath;
        FileNameGenerator fileNameGenerator;
        BackupStrategy backupStrategy;
        LogFormatter logFormatter;

        public Builder(String folderPath) {
            this.folderPath = folderPath;
        }

        public Builder fileNameGenerator(FileNameGenerator fileNameGenerator) {
            this.fileNameGenerator = fileNameGenerator;
            return this;
        }

        public Builder backupStrategy(BackupStrategy backupStrategy) {
            this.backupStrategy = backupStrategy;
            return this;
        }

        public Builder logFormatter(LogFormatter logFormatter) {
            this.logFormatter = logFormatter;
            return this;
        }

        public FilePrinter build() {
            this.fillEmptyFields();
            return new FilePrinter(this);
        }

        private void fillEmptyFields() {
            if (this.fileNameGenerator == null) {
                this.fileNameGenerator = new ChangelessFileNameGenerator(DEFAULT_LOG_FILE_NAME);
            }
            if (this.backupStrategy == null) {
                this.backupStrategy = new FileSizeBackupStrategy(0x100000L);
            }
            if (this.logFormatter == null) {
                this.logFormatter = DefaultFormatterFactory.createLogFormatter();
            }
        }
    }
}

