/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.System;
import com.elvishew.xlog.XLog;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.method.MethodFormatter;
import com.elvishew.xlog.formatter.message.method.MethodInfo;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.util.StackTraceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Logger {
    private static final int BASE_IGNORED_STACK_TRACE_DEPTH = 1;
    private LogConfiguration logConfiguration;
    private List<Printer> printers;

    Logger(LogConfiguration logConfiguration, List<Printer> printers) {
        this.logConfiguration = logConfiguration;
        this.printers = new ArrayList<Printer>(printers);
    }

    Logger(Builder builder) {
        LogConfiguration.Builder logConfigBuilder = new LogConfiguration.Builder(XLog.sLogConfiguration);
        if (builder.tag != null) {
            logConfigBuilder.tag(builder.tag);
        }
        if (builder.jsonFormatter != null) {
            logConfigBuilder.jsonFormatter(builder.jsonFormatter);
        }
        if (builder.xmlFormatter != null) {
            logConfigBuilder.xmlFormatter(builder.xmlFormatter);
        }
        if (builder.methodFormatter != null) {
            logConfigBuilder.methodFormatter(builder.methodFormatter);
        }
        if (builder.throwableFormatter != null) {
            logConfigBuilder.throwableFormatter(builder.throwableFormatter);
        }
        this.logConfiguration = logConfigBuilder.build();
        this.printers = builder.printers != null && builder.printers.length > 0 ? new ArrayList<Printer>(Arrays.asList(builder.printers)) : new ArrayList<Printer>(XLog.sPrinters);
    }

    public void v(String format, Object ... args) {
        this.println(2, String.format(format, args));
    }

    public void v(String msg) {
        this.println(2, msg);
    }

    public void v(String msg, Throwable tr) {
        this.println(2, msg, tr);
    }

    public void d(String format, Object ... args) {
        this.println(3, String.format(format, args));
    }

    public void d(String msg) {
        this.println(3, msg);
    }

    public void d(String msg, Throwable tr) {
        this.println(3, msg, tr);
    }

    public void i(String format, Object ... args) {
        this.println(4, String.format(format, args));
    }

    public void i(String msg) {
        this.println(4, msg);
    }

    public void i(String msg, Throwable tr) {
        this.println(4, msg, tr);
    }

    public void w(String format, Object ... args) {
        this.println(5, String.format(format, args));
    }

    public void w(String msg) {
        this.println(5, msg);
    }

    public void w(String msg, Throwable tr) {
        this.println(5, msg, tr);
    }

    public void e(String format, Object ... args) {
        this.println(6, String.format(format, args));
    }

    public void e(String msg) {
        this.println(6, msg);
    }

    public void e(String msg, Throwable tr) {
        this.println(6, msg, tr);
    }

    void println(int logLevel, String msg) {
        if (logLevel < XLog.sLogLevel) {
            return;
        }
        for (Printer printer : this.printers) {
            printer.println(logLevel, this.logConfiguration, msg);
        }
    }

    void println(int logLevel, String msg, Throwable tr) {
        if (logLevel < XLog.sLogLevel) {
            return;
        }
        for (Printer printer : this.printers) {
            printer.println(logLevel, this.logConfiguration, msg, tr);
        }
    }

    public void json(String json) {
        if (3 < XLog.sLogLevel) {
            return;
        }
        for (Printer printer : this.printers) {
            printer.json(this.logConfiguration, json);
        }
    }

    public void xml(String xml) {
        if (3 < XLog.sLogLevel) {
            return;
        }
        for (Printer printer : this.printers) {
            printer.xml(this.logConfiguration, xml);
        }
    }

    public void method(Object ... arguments) {
        this.method(1, arguments);
    }

    void method(int ignoredStackTraceDepth, Object ... arguments) {
        if (3 < XLog.sLogLevel) {
            return;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int stackTraceDepthForUser = stackTrace.length - ++ignoredStackTraceDepth;
        StackTraceElement[] stackTraceForUser = new StackTraceElement[stackTraceDepthForUser];
        java.lang.System.arraycopy(stackTrace, ignoredStackTraceDepth, stackTraceForUser, 0, stackTraceDepthForUser);
        for (Printer printer : this.printers) {
            printer.method(this.logConfiguration, new MethodInfo(stackTraceForUser, arguments));
        }
    }

    public void stack() {
        this.stack("", 1);
    }

    public void stack(String format, Object ... args) {
        this.stack(String.format(format, args), 1);
    }

    public void stack(String msg) {
        this.stack(msg, 1);
    }

    void stack(String msg, int ignoredStackTraceDepth) {
        this.d((msg == null || msg.trim().length() == 0 ? "" : msg + System.lineSeparator) + StackTraceUtil.getCallStackTraceString(new Throwable().getStackTrace(), ignoredStackTraceDepth + 1));
    }

    public static class Builder {
        private String tag;
        private JsonFormatter jsonFormatter;
        private XmlFormatter xmlFormatter;
        private MethodFormatter methodFormatter;
        private ThrowableFormatter throwableFormatter;
        private Printer[] printers;

        Builder() {
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder jsonFormatter(JsonFormatter jsonFormatter) {
            this.jsonFormatter = jsonFormatter;
            return this;
        }

        public Builder xmlFormatter(XmlFormatter xmlFormatter) {
            this.xmlFormatter = xmlFormatter;
            return this;
        }

        public Builder methodFormatter(MethodFormatter methodFormatter) {
            this.methodFormatter = methodFormatter;
            return this;
        }

        public Builder throwableFormatter(ThrowableFormatter throwableFormatter) {
            this.throwableFormatter = throwableFormatter;
            return this;
        }

        public Builder printers(Printer ... printers) {
            this.printers = printers;
            return this;
        }

        public void v(String format, Object ... args) {
            this.build().v(format, args);
        }

        public void v(String msg) {
            this.build().v(msg);
        }

        public void v(String msg, Throwable tr) {
            this.build().v(msg, tr);
        }

        public void d(String format, Object ... args) {
            this.build().d(format, args);
        }

        public void d(String msg) {
            this.build().d(msg);
        }

        public void d(String msg, Throwable tr) {
            this.build().d(msg, tr);
        }

        public void i(String format, Object ... args) {
            this.build().i(format, args);
        }

        public void i(String msg) {
            this.build().i(msg);
        }

        public void i(String msg, Throwable tr) {
            this.build().i(msg, tr);
        }

        public void w(String format, Object ... args) {
            this.build().w(format, args);
        }

        public void w(String msg) {
            this.build().w(msg);
        }

        public void w(String msg, Throwable tr) {
            this.build().w(msg, tr);
        }

        public void e(String format, Object ... args) {
            this.build().e(format, args);
        }

        public void e(String msg) {
            this.build().e(msg);
        }

        public void e(String msg, Throwable tr) {
            this.build().e(msg, tr);
        }

        public void json(String json) {
            this.build().json(json);
        }

        public void xml(String xml) {
            this.build().xml(xml);
        }

        public void method(Object ... arguments) {
            this.build().method(1, arguments);
        }

        public void stack() {
            this.build().stack("", 1);
        }

        public void stack(String format, Object ... args) {
            this.build().stack(String.format(format, args), 1);
        }

        public void stack(String msg) {
            this.build().stack(msg, 1);
        }

        public Logger build() {
            return new Logger(this);
        }
    }
}

