/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.util;

import com.elvishew.xlog.System;
import com.elvishew.xlog.util.FastPrintWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

public class StackTraceUtil {
    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 256);
        tr.printStackTrace(pw);
        ((PrintWriter)pw).flush();
        return sw.toString();
    }

    public static String getCallStackTraceString(StackTraceElement[] callStack, int ignoredStackTraceDepth) {
        StringBuilder sb = new StringBuilder(256);
        if (callStack != null) {
            for (int i = ignoredStackTraceDepth; i < callStack.length; ++i) {
                sb.append("\tat ");
                sb.append(callStack[i].toString());
                sb.append(System.lineSeparator);
            }
        }
        return sb.toString();
    }
}

