/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.SystemCompat;
import com.elvishew.xlog.XLog;
import com.elvishew.xlog.formatter.border.BorderFormatter;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.object.ObjectFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.formatter.stacktrace.StackTraceFormatter;
import com.elvishew.xlog.formatter.thread.ThreadFormatter;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.PrinterSet;
import com.elvishew.xlog.util.StackTraceUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    private LogConfiguration logConfiguration;
    private Printer printer;

    Logger(LogConfiguration logConfiguration, Printer printer) {
        this.logConfiguration = logConfiguration;
        this.printer = printer;
    }

    Logger(Builder builder) {
        LogConfiguration.Builder logConfigBuilder = new LogConfiguration.Builder(XLog.sLogConfiguration);
        if (builder.tag != null) {
            logConfigBuilder.tag(builder.tag);
        }
        if (builder.threadSet) {
            if (builder.withThread) {
                logConfigBuilder.t();
            } else {
                logConfigBuilder.nt();
            }
        }
        if (builder.stackTraceSet) {
            if (builder.withStackTrace) {
                logConfigBuilder.st(builder.stackTraceDepth);
            } else {
                logConfigBuilder.nst();
            }
        }
        if (builder.borderSet) {
            if (builder.withBorder) {
                logConfigBuilder.b();
            } else {
                logConfigBuilder.nb();
            }
        }
        if (builder.jsonFormatter != null) {
            logConfigBuilder.jsonFormatter(builder.jsonFormatter);
        }
        if (builder.xmlFormatter != null) {
            logConfigBuilder.xmlFormatter(builder.xmlFormatter);
        }
        if (builder.throwableFormatter != null) {
            logConfigBuilder.throwableFormatter(builder.throwableFormatter);
        }
        if (builder.threadFormatter != null) {
            logConfigBuilder.threadFormatter(builder.threadFormatter);
        }
        if (builder.stackTraceFormatter != null) {
            logConfigBuilder.stackTraceFormatter(builder.stackTraceFormatter);
        }
        if (builder.borderFormatter != null) {
            logConfigBuilder.borderFormatter(builder.borderFormatter);
        }
        if (builder.objectFormatters != null) {
            logConfigBuilder.objectFormatters(builder.objectFormatters);
        }
        this.logConfiguration = logConfigBuilder.build();
        this.printer = builder.printer != null ? builder.printer : XLog.sPrinter;
    }

    public void v(Object object) {
        this.println(2, object);
    }

    public void v(Object[] array) {
        this.println(2, array);
    }

    public void v(String format, Object ... args) {
        this.println(2, format, args);
    }

    public void v(String msg) {
        this.println(2, msg);
    }

    public void v(String msg, Throwable tr) {
        this.println(2, msg, tr);
    }

    public void d(Object object) {
        this.println(3, object);
    }

    public void d(Object[] array) {
        this.println(3, array);
    }

    public void d(String format, Object ... args) {
        this.println(3, format, args);
    }

    public void d(String msg) {
        this.println(3, msg);
    }

    public void d(String msg, Throwable tr) {
        this.println(3, msg, tr);
    }

    public void i(Object object) {
        this.println(4, object);
    }

    public void i(Object[] array) {
        this.println(4, array);
    }

    public void i(String format, Object ... args) {
        this.println(4, format, args);
    }

    public void i(String msg) {
        this.println(4, msg);
    }

    public void i(String msg, Throwable tr) {
        this.println(4, msg, tr);
    }

    public void w(Object object) {
        this.println(5, object);
    }

    public void w(Object[] array) {
        this.println(5, array);
    }

    public void w(String format, Object ... args) {
        this.println(5, format, args);
    }

    public void w(String msg) {
        this.println(5, msg);
    }

    public void w(String msg, Throwable tr) {
        this.println(5, msg, tr);
    }

    public void e(Object object) {
        this.println(6, object);
    }

    public void e(Object[] array) {
        this.println(6, array);
    }

    public void e(String format, Object ... args) {
        this.println(6, format, args);
    }

    public void e(String msg) {
        this.println(6, msg);
    }

    public void e(String msg, Throwable tr) {
        this.println(6, msg, tr);
    }

    public void json(String json) {
        if (3 < XLog.sLogLevel) {
            return;
        }
        this.println(3, this.logConfiguration.jsonFormatter.format(json));
    }

    public void xml(String xml) {
        if (3 < XLog.sLogLevel) {
            return;
        }
        this.println(3, this.logConfiguration.xmlFormatter.format(xml));
    }

    private <T> void println(int logLevel, T object) {
        if (logLevel < XLog.sLogLevel) {
            return;
        }
        ObjectFormatter<T> objectFormatter = this.logConfiguration.getObjectFormatter(object);
        if (objectFormatter != null) {
            this.printlnInternal(logLevel, objectFormatter.format(object));
        } else {
            this.printlnInternal(logLevel, object.toString());
        }
    }

    private void println(int logLevel, Object[] array) {
        if (logLevel < XLog.sLogLevel) {
            return;
        }
        this.printlnInternal(logLevel, Arrays.deepToString(array));
    }

    private void println(int logLevel, String format, Object ... args) {
        if (logLevel < XLog.sLogLevel) {
            return;
        }
        this.printlnInternal(logLevel, this.formatArgs(format, args));
    }

    void println(int logLevel, String msg) {
        if (logLevel < XLog.sLogLevel) {
            return;
        }
        this.printlnInternal(logLevel, msg);
    }

    private void println(int logLevel, String msg, Throwable tr) {
        if (logLevel < XLog.sLogLevel) {
            return;
        }
        this.printlnInternal(logLevel, (msg == null || msg.length() == 0 ? "" : msg + SystemCompat.lineSeparator) + this.logConfiguration.throwableFormatter.format(tr));
    }

    private void printlnInternal(int logLevel, String msg) {
        String thread = this.logConfiguration.withThread ? this.logConfiguration.threadFormatter.format(Thread.currentThread()) : null;
        String stackTrace = this.logConfiguration.withStackTrace ? this.logConfiguration.stackTraceFormatter.format(StackTraceUtil.getCroppedRealStackTrack(new Throwable().getStackTrace(), this.logConfiguration.stackTraceDepth)) : null;
        this.printer.println(logLevel, this.logConfiguration.tag, this.logConfiguration.withBorder ? this.logConfiguration.borderFormatter.format(new String[]{thread, stackTrace, msg}) : (thread != null ? thread + SystemCompat.lineSeparator : "") + (stackTrace != null ? stackTrace + SystemCompat.lineSeparator : "") + msg);
    }

    private String formatArgs(String format, Object ... args) {
        if (format != null) {
            return String.format(format, args);
        }
        StringBuilder sb = new StringBuilder();
        int N = args.length;
        for (int i = 0; i < N; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static class Builder {
        private String tag;
        private boolean withThread;
        private boolean threadSet;
        private boolean withStackTrace;
        private int stackTraceDepth;
        private boolean stackTraceSet;
        private boolean withBorder;
        private boolean borderSet;
        private JsonFormatter jsonFormatter;
        private XmlFormatter xmlFormatter;
        private ThrowableFormatter throwableFormatter;
        private ThreadFormatter threadFormatter;
        private StackTraceFormatter stackTraceFormatter;
        private BorderFormatter borderFormatter;
        private Map<Class<?>, ObjectFormatter<?>> objectFormatters;
        private Printer printer;

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder t() {
            this.withThread = true;
            this.threadSet = true;
            return this;
        }

        public Builder nt() {
            this.withThread = false;
            this.threadSet = true;
            return this;
        }

        public Builder st(int depth) {
            this.withStackTrace = true;
            this.stackTraceDepth = depth;
            this.stackTraceSet = true;
            return this;
        }

        public Builder nst() {
            this.withStackTrace = false;
            this.stackTraceDepth = 0;
            this.stackTraceSet = true;
            return this;
        }

        public Builder b() {
            this.withBorder = true;
            this.borderSet = true;
            return this;
        }

        public Builder nb() {
            this.withBorder = false;
            this.borderSet = true;
            return this;
        }

        public Builder jsonFormatter(JsonFormatter jsonFormatter) {
            this.jsonFormatter = jsonFormatter;
            return this;
        }

        public Builder xmlFormatter(XmlFormatter xmlFormatter) {
            this.xmlFormatter = xmlFormatter;
            return this;
        }

        public Builder throwableFormatter(ThrowableFormatter throwableFormatter) {
            this.throwableFormatter = throwableFormatter;
            return this;
        }

        public Builder threadFormatter(ThreadFormatter threadFormatter) {
            this.threadFormatter = threadFormatter;
            return this;
        }

        public Builder stackTraceFormatter(StackTraceFormatter stackTraceFormatter) {
            this.stackTraceFormatter = stackTraceFormatter;
            return this;
        }

        public Builder borderFormatter(BorderFormatter borderFormatter) {
            this.borderFormatter = borderFormatter;
            return this;
        }

        public <T> Builder addObjectFormatter(Class<T> objectClass, ObjectFormatter<? super T> objectFormatter) {
            if (this.objectFormatters == null) {
                this.objectFormatters = new HashMap(5);
            }
            this.objectFormatters.put(objectClass, objectFormatter);
            return this;
        }

        public Builder printers(Printer ... printers) {
            this.printer = printers.length == 0 ? null : (printers.length == 1 ? printers[0] : new PrinterSet(printers));
            return this;
        }

        public void v(Object object) {
            this.build().v(object);
        }

        public void v(String format, Object ... args) {
            this.build().v(format, args);
        }

        public void v(String msg) {
            this.build().v(msg);
        }

        public void v(String msg, Throwable tr) {
            this.build().v(msg, tr);
        }

        public void d(Object object) {
            this.build().d(object);
        }

        public void d(String format, Object ... args) {
            this.build().d(format, args);
        }

        public void d(String msg) {
            this.build().d(msg);
        }

        public void d(String msg, Throwable tr) {
            this.build().d(msg, tr);
        }

        public void i(Object object) {
            this.build().i(object);
        }

        public void i(String format, Object ... args) {
            this.build().i(format, args);
        }

        public void i(String msg) {
            this.build().i(msg);
        }

        public void i(String msg, Throwable tr) {
            this.build().i(msg, tr);
        }

        public void w(Object object) {
            this.build().w(object);
        }

        public void w(String format, Object ... args) {
            this.build().w(format, args);
        }

        public void w(String msg) {
            this.build().w(msg);
        }

        public void w(String msg, Throwable tr) {
            this.build().w(msg, tr);
        }

        public void e(Object object) {
            this.build().e(object);
        }

        public void e(String format, Object ... args) {
            this.build().e(format, args);
        }

        public void e(String msg) {
            this.build().e(msg);
        }

        public void e(String msg, Throwable tr) {
            this.build().e(msg, tr);
        }

        public void json(String json) {
            this.build().json(json);
        }

        public void xml(String xml) {
            this.build().xml(xml);
        }

        public Logger build() {
            return new Logger(this);
        }
    }
}

