/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.LogItem;
import com.elvishew.xlog.XLog;
import com.elvishew.xlog.formatter.border.BorderFormatter;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.object.ObjectFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.formatter.stacktrace.StackTraceFormatter;
import com.elvishew.xlog.formatter.thread.ThreadFormatter;
import com.elvishew.xlog.interceptor.Interceptor;
import com.elvishew.xlog.internal.DefaultsFactory;
import com.elvishew.xlog.internal.Platform;
import com.elvishew.xlog.internal.SystemCompat;
import com.elvishew.xlog.internal.util.StackTraceUtil;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.PrinterSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Logger {
    private LogConfiguration logConfiguration;
    private Printer printer;

    Logger(LogConfiguration logConfiguration, Printer printer) {
        this.logConfiguration = logConfiguration;
        this.printer = printer;
    }

    Logger(Builder builder) {
        LogConfiguration.Builder logConfigBuilder = new LogConfiguration.Builder(XLog.sLogConfiguration);
        if (builder.logLevel != 0) {
            logConfigBuilder.logLevel(builder.logLevel);
        }
        if (builder.tag != null) {
            logConfigBuilder.tag(builder.tag);
        }
        if (builder.threadSet) {
            if (builder.withThread) {
                logConfigBuilder.enableThreadInfo();
            } else {
                logConfigBuilder.disableThreadInfo();
            }
        }
        if (builder.stackTraceSet) {
            if (builder.withStackTrace) {
                logConfigBuilder.enableStackTrace(builder.stackTraceOrigin, builder.stackTraceDepth);
            } else {
                logConfigBuilder.disableStackTrace();
            }
        }
        if (builder.borderSet) {
            if (builder.withBorder) {
                logConfigBuilder.enableBorder();
            } else {
                logConfigBuilder.disableBorder();
            }
        }
        if (builder.jsonFormatter != null) {
            logConfigBuilder.jsonFormatter(builder.jsonFormatter);
        }
        if (builder.xmlFormatter != null) {
            logConfigBuilder.xmlFormatter(builder.xmlFormatter);
        }
        if (builder.throwableFormatter != null) {
            logConfigBuilder.throwableFormatter(builder.throwableFormatter);
        }
        if (builder.threadFormatter != null) {
            logConfigBuilder.threadFormatter(builder.threadFormatter);
        }
        if (builder.stackTraceFormatter != null) {
            logConfigBuilder.stackTraceFormatter(builder.stackTraceFormatter);
        }
        if (builder.borderFormatter != null) {
            logConfigBuilder.borderFormatter(builder.borderFormatter);
        }
        if (builder.objectFormatters != null) {
            logConfigBuilder.objectFormatters(builder.objectFormatters);
        }
        if (builder.interceptors != null) {
            logConfigBuilder.interceptors(builder.interceptors);
        }
        this.logConfiguration = logConfigBuilder.build();
        this.printer = builder.printer != null ? builder.printer : XLog.sPrinter;
    }

    public void v(Object object) {
        this.println(2, object);
    }

    public void v(Object[] array) {
        this.println(2, array);
    }

    public void v(String format, Object ... args) {
        this.println(2, format, args);
    }

    public void v(String msg) {
        this.println(2, msg);
    }

    public void v(String msg, Throwable tr) {
        this.println(2, msg, tr);
    }

    public void d(Object object) {
        this.println(3, object);
    }

    public void d(Object[] array) {
        this.println(3, array);
    }

    public void d(String format, Object ... args) {
        this.println(3, format, args);
    }

    public void d(String msg) {
        this.println(3, msg);
    }

    public void d(String msg, Throwable tr) {
        this.println(3, msg, tr);
    }

    public void i(Object object) {
        this.println(4, object);
    }

    public void i(Object[] array) {
        this.println(4, array);
    }

    public void i(String format, Object ... args) {
        this.println(4, format, args);
    }

    public void i(String msg) {
        this.println(4, msg);
    }

    public void i(String msg, Throwable tr) {
        this.println(4, msg, tr);
    }

    public void w(Object object) {
        this.println(5, object);
    }

    public void w(Object[] array) {
        this.println(5, array);
    }

    public void w(String format, Object ... args) {
        this.println(5, format, args);
    }

    public void w(String msg) {
        this.println(5, msg);
    }

    public void w(String msg, Throwable tr) {
        this.println(5, msg, tr);
    }

    public void e(Object object) {
        this.println(6, object);
    }

    public void e(Object[] array) {
        this.println(6, array);
    }

    public void e(String format, Object ... args) {
        this.println(6, format, args);
    }

    public void e(String msg) {
        this.println(6, msg);
    }

    public void e(String msg, Throwable tr) {
        this.println(6, msg, tr);
    }

    public void log(int logLevel, Object object) {
        this.println(logLevel, object);
    }

    public void log(int logLevel, Object[] array) {
        this.println(logLevel, array);
    }

    public void log(int logLevel, String format, Object ... args) {
        this.println(logLevel, format, args);
    }

    public void log(int logLevel, String msg) {
        this.println(logLevel, msg);
    }

    public void log(int logLevel, String msg, Throwable tr) {
        this.println(logLevel, msg, tr);
    }

    public void json(String json) {
        if (3 < this.logConfiguration.logLevel) {
            return;
        }
        this.printlnInternal(3, this.logConfiguration.jsonFormatter.format(json));
    }

    public void xml(String xml) {
        if (3 < this.logConfiguration.logLevel) {
            return;
        }
        this.printlnInternal(3, this.logConfiguration.xmlFormatter.format(xml));
    }

    private <T> void println(int logLevel, T object) {
        ObjectFormatter<T> objectFormatter;
        if (logLevel < this.logConfiguration.logLevel) {
            return;
        }
        String objectString = object != null ? ((objectFormatter = this.logConfiguration.getObjectFormatter(object)) != null ? objectFormatter.format(object) : object.toString()) : "null";
        this.printlnInternal(logLevel, objectString);
    }

    private void println(int logLevel, Object[] array) {
        if (logLevel < this.logConfiguration.logLevel) {
            return;
        }
        this.printlnInternal(logLevel, Arrays.deepToString(array));
    }

    private void println(int logLevel, String format, Object ... args) {
        if (logLevel < this.logConfiguration.logLevel) {
            return;
        }
        this.printlnInternal(logLevel, this.formatArgs(format, args));
    }

    void println(int logLevel, String msg) {
        if (logLevel < this.logConfiguration.logLevel) {
            return;
        }
        this.printlnInternal(logLevel, msg);
    }

    private void println(int logLevel, String msg, Throwable tr) {
        if (logLevel < this.logConfiguration.logLevel) {
            return;
        }
        this.printlnInternal(logLevel, (msg == null || msg.length() == 0 ? "" : msg + SystemCompat.lineSeparator) + this.logConfiguration.throwableFormatter.format(tr));
    }

    private void printlnInternal(int logLevel, String msg) {
        String stackTrace;
        String tag = this.logConfiguration.tag;
        String thread = this.logConfiguration.withThread ? this.logConfiguration.threadFormatter.format(Thread.currentThread()) : null;
        String string = stackTrace = this.logConfiguration.withStackTrace ? this.logConfiguration.stackTraceFormatter.format(StackTraceUtil.getCroppedRealStackTrack(new Throwable().getStackTrace(), this.logConfiguration.stackTraceOrigin, this.logConfiguration.stackTraceDepth)) : null;
        if (this.logConfiguration.interceptors != null) {
            LogItem log = new LogItem(logLevel, tag, thread, stackTrace, msg);
            for (Interceptor interceptor : this.logConfiguration.interceptors) {
                log = interceptor.intercept(log);
                if (log == null) {
                    return;
                }
                if (log.tag != null && log.msg != null) continue;
                Platform.get().error("Interceptor " + interceptor + " should not remove the tag or message of a log, if you don't want to print this log, just return a null when intercept.");
                return;
            }
            logLevel = log.level;
            tag = log.tag;
            thread = log.threadInfo;
            stackTrace = log.stackTraceInfo;
            msg = log.msg;
        }
        this.printer.println(logLevel, tag, this.logConfiguration.withBorder ? this.logConfiguration.borderFormatter.format(new String[]{thread, stackTrace, msg}) : (thread != null ? thread + SystemCompat.lineSeparator : "") + (stackTrace != null ? stackTrace + SystemCompat.lineSeparator : "") + msg);
    }

    private String formatArgs(String format, Object ... args) {
        if (format != null) {
            return String.format(format, args);
        }
        StringBuilder sb = new StringBuilder();
        int N = args.length;
        for (int i = 0; i < N; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static class Builder {
        private int logLevel;
        private String tag;
        private boolean withThread;
        private boolean threadSet;
        private boolean withStackTrace;
        private String stackTraceOrigin;
        private int stackTraceDepth;
        private boolean stackTraceSet;
        private boolean withBorder;
        private boolean borderSet;
        private JsonFormatter jsonFormatter;
        private XmlFormatter xmlFormatter;
        private ThrowableFormatter throwableFormatter;
        private ThreadFormatter threadFormatter;
        private StackTraceFormatter stackTraceFormatter;
        private BorderFormatter borderFormatter;
        private Map<Class<?>, ObjectFormatter<?>> objectFormatters;
        private List<Interceptor> interceptors;
        private Printer printer;

        public Builder() {
            XLog.assertInitialization();
        }

        public Builder logLevel(int logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        @Deprecated
        public Builder t() {
            return this.enableThreadInfo();
        }

        public Builder enableThreadInfo() {
            this.withThread = true;
            this.threadSet = true;
            return this;
        }

        @Deprecated
        public Builder nt() {
            return this.disableThreadInfo();
        }

        public Builder disableThreadInfo() {
            this.withThread = false;
            this.threadSet = true;
            return this;
        }

        @Deprecated
        public Builder st(int depth) {
            return this.enableStackTrace(depth);
        }

        public Builder enableStackTrace(int depth) {
            this.withStackTrace = true;
            this.stackTraceDepth = depth;
            this.stackTraceSet = true;
            return this;
        }

        @Deprecated
        public Builder st(String stackTraceOrigin, int depth) {
            return this.enableStackTrace(stackTraceOrigin, depth);
        }

        public Builder enableStackTrace(String stackTraceOrigin, int depth) {
            this.withStackTrace = true;
            this.stackTraceOrigin = stackTraceOrigin;
            this.stackTraceDepth = depth;
            this.stackTraceSet = true;
            return this;
        }

        @Deprecated
        public Builder nst() {
            return this.disableStackTrace();
        }

        public Builder disableStackTrace() {
            this.withStackTrace = false;
            this.stackTraceOrigin = null;
            this.stackTraceDepth = 0;
            this.stackTraceSet = true;
            return this;
        }

        @Deprecated
        public Builder b() {
            return this.enableBorder();
        }

        public Builder enableBorder() {
            this.withBorder = true;
            this.borderSet = true;
            return this;
        }

        @Deprecated
        public Builder nb() {
            return this.disableBorder();
        }

        public Builder disableBorder() {
            this.withBorder = false;
            this.borderSet = true;
            return this;
        }

        public Builder jsonFormatter(JsonFormatter jsonFormatter) {
            this.jsonFormatter = jsonFormatter;
            return this;
        }

        public Builder xmlFormatter(XmlFormatter xmlFormatter) {
            this.xmlFormatter = xmlFormatter;
            return this;
        }

        public Builder throwableFormatter(ThrowableFormatter throwableFormatter) {
            this.throwableFormatter = throwableFormatter;
            return this;
        }

        public Builder threadFormatter(ThreadFormatter threadFormatter) {
            this.threadFormatter = threadFormatter;
            return this;
        }

        public Builder stackTraceFormatter(StackTraceFormatter stackTraceFormatter) {
            this.stackTraceFormatter = stackTraceFormatter;
            return this;
        }

        public Builder borderFormatter(BorderFormatter borderFormatter) {
            this.borderFormatter = borderFormatter;
            return this;
        }

        public <T> Builder addObjectFormatter(Class<T> objectClass, ObjectFormatter<? super T> objectFormatter) {
            if (this.objectFormatters == null) {
                this.objectFormatters = new HashMap(DefaultsFactory.builtinObjectFormatters());
            }
            this.objectFormatters.put(objectClass, objectFormatter);
            return this;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<Interceptor>();
            }
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder printers(Printer ... printers) {
            this.printer = printers.length == 0 ? null : (printers.length == 1 ? printers[0] : new PrinterSet(printers));
            return this;
        }

        public void v(Object object) {
            this.build().v(object);
        }

        public void v(Object[] array) {
            this.build().v(array);
        }

        public void v(String format, Object ... args) {
            this.build().v(format, args);
        }

        public void v(String msg) {
            this.build().v(msg);
        }

        public void v(String msg, Throwable tr) {
            this.build().v(msg, tr);
        }

        public void d(Object object) {
            this.build().d(object);
        }

        public void d(Object[] array) {
            this.build().d(array);
        }

        public void d(String format, Object ... args) {
            this.build().d(format, args);
        }

        public void d(String msg) {
            this.build().d(msg);
        }

        public void d(String msg, Throwable tr) {
            this.build().d(msg, tr);
        }

        public void i(Object object) {
            this.build().i(object);
        }

        public void i(Object[] array) {
            this.build().i(array);
        }

        public void i(String format, Object ... args) {
            this.build().i(format, args);
        }

        public void i(String msg) {
            this.build().i(msg);
        }

        public void i(String msg, Throwable tr) {
            this.build().i(msg, tr);
        }

        public void w(Object object) {
            this.build().w(object);
        }

        public void w(Object[] array) {
            this.build().w(array);
        }

        public void w(String format, Object ... args) {
            this.build().w(format, args);
        }

        public void w(String msg) {
            this.build().w(msg);
        }

        public void w(String msg, Throwable tr) {
            this.build().w(msg, tr);
        }

        public void e(Object object) {
            this.build().e(object);
        }

        public void e(Object[] array) {
            this.build().e(array);
        }

        public void e(String format, Object ... args) {
            this.build().e(format, args);
        }

        public void e(String msg) {
            this.build().e(msg);
        }

        public void e(String msg, Throwable tr) {
            this.build().e(msg, tr);
        }

        public void log(int logLevel, Object object) {
            this.build().log(logLevel, object);
        }

        public void log(int logLevel, Object[] array) {
            this.build().log(logLevel, array);
        }

        public void log(int logLevel, String format, Object ... args) {
            this.build().log(logLevel, format, args);
        }

        public void log(int logLevel, String msg) {
            this.build().log(logLevel, msg);
        }

        public void log(int logLevel, String msg, Throwable tr) {
            this.build().log(logLevel, msg, tr);
        }

        public void json(String json) {
            this.build().json(json);
        }

        public void xml(String xml) {
            this.build().xml(xml);
        }

        public Logger build() {
            return new Logger(this);
        }
    }
}

