/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.formatter.message.xml;

import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.internal.Platform;
import com.elvishew.xlog.internal.SystemCompat;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class DefaultXmlFormatter
implements XmlFormatter {
    private static final int XML_INDENT = 4;

    @Override
    public String format(String xml) {
        String formattedString;
        if (xml == null || xml.trim().length() == 0) {
            Platform.get().warn("XML empty.");
            return "";
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(4));
            transformer.transform(xmlInput, xmlOutput);
            formattedString = xmlOutput.getWriter().toString().replaceFirst(">", ">" + SystemCompat.lineSeparator);
        }
        catch (Exception e) {
            Platform.get().warn(e.getMessage());
            return xml;
        }
        return formattedString;
    }
}

