/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.printer.file.writer;

import com.elvishew.xlog.internal.Platform;
import com.elvishew.xlog.printer.file.writer.Writer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class SimpleWriter
extends Writer {
    private String logFileName;
    private File logFile;
    private BufferedWriter bufferedWriter;

    @Override
    public boolean open(File file) {
        this.logFileName = file.getName();
        this.logFile = file;
        boolean isNewFile = false;
        if (!this.logFile.exists()) {
            try {
                File parent = this.logFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                this.logFile.createNewFile();
                isNewFile = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close();
                return false;
            }
        }
        try {
            this.bufferedWriter = new BufferedWriter(new FileWriter(this.logFile, true));
            if (isNewFile) {
                this.onNewFileCreated(this.logFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public boolean isOpened() {
        return this.bufferedWriter != null && this.logFile.exists();
    }

    @Override
    public File getOpenedFile() {
        return this.logFile;
    }

    @Override
    public String getOpenedFileName() {
        return this.logFileName;
    }

    public void onNewFileCreated(File file) {
    }

    @Override
    public void appendLog(String log) {
        try {
            this.bufferedWriter.write(log);
            this.bufferedWriter.newLine();
            this.bufferedWriter.flush();
        }
        catch (Exception e) {
            Platform.get().warn("append log failed: " + e.getMessage());
        }
    }

    @Override
    public boolean close() {
        if (this.bufferedWriter != null) {
            try {
                this.bufferedWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.bufferedWriter = null;
        this.logFileName = null;
        this.logFile = null;
        return true;
    }
}

