/*
 * Copyright 2015 Elvis Hew
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.elvishew.xlog.printer;

/**
 * Log {@link Printer} using {@link android.util.Log}.
 */
public class AndroidPrinter implements Printer {

  static final int MAX_LENGTH_OF_SINGLE_MESSAGE = 4063;

  @Override
  public void println(int logLevel, String tag, String msg) {
    if (msg.length() <= MAX_LENGTH_OF_SINGLE_MESSAGE) {
      printChunk(logLevel, tag, msg);
      return;
    }

    int msgLength = msg.length();
    int start = 0;
    int end = start + MAX_LENGTH_OF_SINGLE_MESSAGE;
    while (start < msgLength) {
      printChunk(logLevel, tag, msg.substring(start, end));

      start = end;
      end = Math.min(start + MAX_LENGTH_OF_SINGLE_MESSAGE, msgLength);
    }
  }

  /**
   * Print single chunk of log in new line.
   *
   * @param logLevel the level of log
   * @param tag      the tag of log
   * @param msg      the msg of log
   */
  void printChunk(int logLevel, String tag, String msg) {
    android.util.Log.println(logLevel, tag, msg);
  }
}
