/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

import com.elvishew.xlog.formatter.border.BorderFormatter;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.object.ObjectFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.formatter.stacktrace.StackTraceFormatter;
import com.elvishew.xlog.formatter.thread.ThreadFormatter;
import com.elvishew.xlog.internal.DefaultsFactory;
import java.util.HashMap;
import java.util.Map;

public class LogConfiguration {
    public final String tag;
    public final boolean withThread;
    public final boolean withStackTrace;
    public final int stackTraceDepth;
    public final boolean withBorder;
    public final JsonFormatter jsonFormatter;
    public final XmlFormatter xmlFormatter;
    public final ThrowableFormatter throwableFormatter;
    public final ThreadFormatter threadFormatter;
    public final StackTraceFormatter stackTraceFormatter;
    public final BorderFormatter borderFormatter;
    private final Map<Class<?>, ObjectFormatter<?>> objectFormatters;

    LogConfiguration(Builder builder) {
        this.tag = builder.tag;
        this.withThread = builder.withThread;
        this.withStackTrace = builder.withStackTrace;
        this.stackTraceDepth = builder.stackTraceDepth;
        this.withBorder = builder.withBorder;
        this.jsonFormatter = builder.jsonFormatter;
        this.xmlFormatter = builder.xmlFormatter;
        this.throwableFormatter = builder.throwableFormatter;
        this.threadFormatter = builder.threadFormatter;
        this.stackTraceFormatter = builder.stackTraceFormatter;
        this.borderFormatter = builder.borderFormatter;
        this.objectFormatters = builder.objectFormatters;
    }

    public <T> ObjectFormatter<? super T> getObjectFormatter(T object) {
        ObjectFormatter<?> formatter;
        if (this.objectFormatters == null) {
            return null;
        }
        Class<?> superClazz = object.getClass();
        do {
            Class<?> clazz = superClazz;
            formatter = this.objectFormatters.get(clazz);
            superClazz = clazz.getSuperclass();
        } while (formatter == null && superClazz != null);
        return formatter;
    }

    public static class Builder {
        private static final String DEFAULT_TAG = "X-LOG";
        private String tag = "X-LOG";
        private boolean withThread;
        private boolean withStackTrace;
        private int stackTraceDepth;
        private boolean withBorder;
        private JsonFormatter jsonFormatter;
        private XmlFormatter xmlFormatter;
        private ThrowableFormatter throwableFormatter;
        private ThreadFormatter threadFormatter;
        private StackTraceFormatter stackTraceFormatter;
        private BorderFormatter borderFormatter;
        private Map<Class<?>, ObjectFormatter<?>> objectFormatters;

        public Builder() {
        }

        public Builder(LogConfiguration logConfiguration) {
            this.tag = logConfiguration.tag;
            this.withThread = logConfiguration.withThread;
            this.withStackTrace = logConfiguration.withStackTrace;
            this.stackTraceDepth = logConfiguration.stackTraceDepth;
            this.withBorder = logConfiguration.withBorder;
            this.jsonFormatter = logConfiguration.jsonFormatter;
            this.xmlFormatter = logConfiguration.xmlFormatter;
            this.throwableFormatter = logConfiguration.throwableFormatter;
            this.threadFormatter = logConfiguration.threadFormatter;
            this.stackTraceFormatter = logConfiguration.stackTraceFormatter;
            this.borderFormatter = logConfiguration.borderFormatter;
            if (logConfiguration.objectFormatters != null) {
                this.objectFormatters = new HashMap(logConfiguration.objectFormatters);
            }
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder t() {
            this.withThread = true;
            return this;
        }

        public Builder nt() {
            this.withThread = false;
            return this;
        }

        public Builder st(int depth) {
            this.withStackTrace = true;
            this.stackTraceDepth = depth;
            return this;
        }

        public Builder nst() {
            this.withStackTrace = false;
            this.stackTraceDepth = 0;
            return this;
        }

        public Builder b() {
            this.withBorder = true;
            return this;
        }

        public Builder nb() {
            this.withBorder = false;
            return this;
        }

        public Builder jsonFormatter(JsonFormatter jsonFormatter) {
            this.jsonFormatter = jsonFormatter;
            return this;
        }

        public Builder xmlFormatter(XmlFormatter xmlFormatter) {
            this.xmlFormatter = xmlFormatter;
            return this;
        }

        public Builder throwableFormatter(ThrowableFormatter throwableFormatter) {
            this.throwableFormatter = throwableFormatter;
            return this;
        }

        public Builder threadFormatter(ThreadFormatter threadFormatter) {
            this.threadFormatter = threadFormatter;
            return this;
        }

        public Builder stackTraceFormatter(StackTraceFormatter stackTraceFormatter) {
            this.stackTraceFormatter = stackTraceFormatter;
            return this;
        }

        public Builder borderFormatter(BorderFormatter borderFormatter) {
            this.borderFormatter = borderFormatter;
            return this;
        }

        public <T> Builder addObjectFormatter(Class<T> objectClass, ObjectFormatter<? super T> objectFormatter) {
            if (this.objectFormatters == null) {
                this.objectFormatters = new HashMap(5);
            }
            this.objectFormatters.put(objectClass, objectFormatter);
            return this;
        }

        Builder objectFormatters(Map<Class<?>, ObjectFormatter<?>> objectFormatters) {
            this.objectFormatters = objectFormatters;
            return this;
        }

        public LogConfiguration build() {
            this.initEmptyFieldsWithDefaultValues();
            return new LogConfiguration(this);
        }

        private void initEmptyFieldsWithDefaultValues() {
            if (this.jsonFormatter == null) {
                this.jsonFormatter = DefaultsFactory.createJsonFormatter();
            }
            if (this.xmlFormatter == null) {
                this.xmlFormatter = DefaultsFactory.createXmlFormatter();
            }
            if (this.throwableFormatter == null) {
                this.throwableFormatter = DefaultsFactory.createThrowableFormatter();
            }
            if (this.threadFormatter == null) {
                this.threadFormatter = DefaultsFactory.createThreadFormatter();
            }
            if (this.stackTraceFormatter == null) {
                this.stackTraceFormatter = DefaultsFactory.createStackTraceFormatter();
            }
            if (this.borderFormatter == null) {
                this.borderFormatter = DefaultsFactory.createBorderFormatter();
            }
        }
    }
}

