/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.internal;

import com.elvishew.xlog.formatter.border.BorderFormatter;
import com.elvishew.xlog.formatter.border.DefaultBorderFormatter;
import com.elvishew.xlog.formatter.message.json.DefaultJsonFormatter;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.throwable.DefaultThrowableFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.DefaultXmlFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.formatter.stacktrace.DefaultStackTraceFormatter;
import com.elvishew.xlog.formatter.stacktrace.StackTraceFormatter;
import com.elvishew.xlog.formatter.thread.DefaultThreadFormatter;
import com.elvishew.xlog.formatter.thread.ThreadFormatter;
import com.elvishew.xlog.printer.AndroidPrinter;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.backup.BackupStrategy;
import com.elvishew.xlog.printer.file.backup.FileSizeBackupStrategy;
import com.elvishew.xlog.printer.file.naming.ChangelessFileNameGenerator;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import com.elvishew.xlog.printer.flattener.DefaultLogFlattener;
import com.elvishew.xlog.printer.flattener.LogFlattener;

public class DefaultsFactory {
    private static final String DEFAULT_LOG_FILE_NAME = "log";
    private static final long DEFAULT_LOG_FILE_MAX_SIZE = 0x100000L;

    public static JsonFormatter createJsonFormatter() {
        return new DefaultJsonFormatter();
    }

    public static XmlFormatter createXmlFormatter() {
        return new DefaultXmlFormatter();
    }

    public static ThrowableFormatter createThrowableFormatter() {
        return new DefaultThrowableFormatter();
    }

    public static ThreadFormatter createThreadFormatter() {
        return new DefaultThreadFormatter();
    }

    public static StackTraceFormatter createStackTraceFormatter() {
        return new DefaultStackTraceFormatter();
    }

    public static BorderFormatter createBorderFormatter() {
        return new DefaultBorderFormatter();
    }

    public static LogFlattener createLogFlattener() {
        return new DefaultLogFlattener();
    }

    public static Printer createPrinter() {
        return new AndroidPrinter();
    }

    public static FileNameGenerator createFileNameGenerator() {
        return new ChangelessFileNameGenerator(DEFAULT_LOG_FILE_NAME);
    }

    public static BackupStrategy createBackupStrategy() {
        return new FileSizeBackupStrategy(0x100000L);
    }
}

