/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.printer.file;

import com.elvishew.xlog.internal.DefaultsFactory;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.backup.BackupStrategy;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import com.elvishew.xlog.printer.flattener.LogFlattener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class FilePrinter
implements Printer {
    private final String folderPath;
    private final FileNameGenerator fileNameGenerator;
    private final BackupStrategy backupStrategy;
    private LogFlattener logFlattener;
    private BufferedWriter mBufferedWriter;
    private String lastFileName;
    private File logFile;

    FilePrinter(Builder builder) {
        this.folderPath = builder.folderPath;
        this.fileNameGenerator = builder.fileNameGenerator;
        this.backupStrategy = builder.backupStrategy;
        this.logFlattener = builder.logFlattener;
        this.checkLogFolder();
    }

    @Override
    public void println(int logLevel, String tag, String msg) {
        if (this.lastFileName == null || this.fileNameGenerator.isFileNameChangeable()) {
            String newFileName = this.fileNameGenerator.generateFileName(logLevel, System.currentTimeMillis());
            if (newFileName == null || newFileName.trim().length() == 0) {
                throw new IllegalArgumentException("File name should not be empty.");
            }
            if (!newFileName.equals(this.lastFileName)) {
                if (this.mBufferedWriter != null) {
                    this.closeLogWriter();
                }
                this.lastFileName = newFileName;
                this.openLogWriter();
            }
        }
        if (this.mBufferedWriter == null) {
            return;
        }
        if (this.backupStrategy.shouldBackup(this.logFile)) {
            this.closeLogWriter();
            File backupFile = new File(this.folderPath, this.lastFileName + ".bak");
            if (backupFile.exists()) {
                backupFile.delete();
            }
            this.logFile.renameTo(backupFile);
            this.openLogWriter();
            if (this.mBufferedWriter == null) {
                return;
            }
        }
        try {
            String flattenedLog = this.logFlattener.flatten(logLevel, tag, msg).toString();
            this.mBufferedWriter.write(flattenedLog);
            this.mBufferedWriter.newLine();
            this.mBufferedWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkLogFolder() {
        File folder = new File(this.folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    private void openLogWriter() {
        this.logFile = new File(this.folderPath, this.lastFileName);
        if (!this.logFile.exists()) {
            try {
                File parent = this.logFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.lastFileName = null;
                this.logFile = null;
                return;
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.logFile, true);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            this.mBufferedWriter = new BufferedWriter(osw);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.lastFileName = null;
            this.logFile = null;
        }
    }

    private void closeLogWriter() {
        try {
            if (this.mBufferedWriter != null) {
                this.mBufferedWriter.close();
                this.mBufferedWriter = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        String folderPath;
        FileNameGenerator fileNameGenerator;
        BackupStrategy backupStrategy;
        LogFlattener logFlattener;

        public Builder(String folderPath) {
            this.folderPath = folderPath;
        }

        public Builder fileNameGenerator(FileNameGenerator fileNameGenerator) {
            this.fileNameGenerator = fileNameGenerator;
            return this;
        }

        public Builder backupStrategy(BackupStrategy backupStrategy) {
            this.backupStrategy = backupStrategy;
            return this;
        }

        public Builder logFlattener(LogFlattener logFlattener) {
            this.logFlattener = logFlattener;
            return this;
        }

        public FilePrinter build() {
            this.fillEmptyFields();
            return new FilePrinter(this);
        }

        private void fillEmptyFields() {
            if (this.fileNameGenerator == null) {
                this.fileNameGenerator = DefaultsFactory.createFileNameGenerator();
            }
            if (this.backupStrategy == null) {
                this.backupStrategy = DefaultsFactory.createBackupStrategy();
            }
            if (this.logFlattener == null) {
                this.logFlattener = DefaultsFactory.createLogFlattener();
            }
        }
    }
}

