/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.internal;

import android.annotation.SuppressLint;
import android.os.Build;
import com.elvishew.xlog.printer.AndroidPrinter;
import com.elvishew.xlog.printer.ConsolePrinter;
import com.elvishew.xlog.printer.Printer;

class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    @SuppressLint(value={"NewApi"})
    String lineSeparator() {
        return System.lineSeparator();
    }

    Printer defaultPrinter() {
        return new ConsolePrinter();
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Platform();
    }

    static class Android
    extends Platform {
        Android() {
        }

        @Override
        String lineSeparator() {
            if (Build.VERSION.SDK_INT < 19) {
                return "\n";
            }
            return System.lineSeparator();
        }

        @Override
        Printer defaultPrinter() {
            return new AndroidPrinter();
        }
    }
}

