/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.printer;

import android.util.Log;
import com.elvishew.xlog.printer.Printer;

public class AndroidPrinter
implements Printer {
    static final int MAX_LENGTH_OF_SINGLE_MESSAGE = 4063;

    @Override
    public void println(int logLevel, String tag, String msg) {
        if (msg.length() <= 4063) {
            this.printChunk(logLevel, tag, msg);
            return;
        }
        int msgLength = msg.length();
        int start = 0;
        int end = start + 4063;
        while (start < msgLength) {
            this.printChunk(logLevel, tag, msg.substring(start, end));
            start = end;
            end = Math.min(start + 4063, msgLength);
        }
    }

    void printChunk(int logLevel, String tag, String msg) {
        Log.println((int)logLevel, (String)tag, (String)msg);
    }
}

