/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.internal;

import android.content.Intent;
import android.os.Bundle;
import com.elvishew.xlog.flattener.DefaultFlattener;
import com.elvishew.xlog.flattener.Flattener;
import com.elvishew.xlog.formatter.border.BorderFormatter;
import com.elvishew.xlog.formatter.border.DefaultBorderFormatter;
import com.elvishew.xlog.formatter.message.json.DefaultJsonFormatter;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.object.BundleFormatter;
import com.elvishew.xlog.formatter.message.object.IntentFormatter;
import com.elvishew.xlog.formatter.message.object.ObjectFormatter;
import com.elvishew.xlog.formatter.message.throwable.DefaultThrowableFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.DefaultXmlFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.formatter.stacktrace.DefaultStackTraceFormatter;
import com.elvishew.xlog.formatter.stacktrace.StackTraceFormatter;
import com.elvishew.xlog.formatter.thread.DefaultThreadFormatter;
import com.elvishew.xlog.formatter.thread.ThreadFormatter;
import com.elvishew.xlog.internal.Platform;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.backup.BackupStrategy;
import com.elvishew.xlog.printer.file.backup.FileSizeBackupStrategy;
import com.elvishew.xlog.printer.file.naming.ChangelessFileNameGenerator;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultsFactory {
    private static final String DEFAULT_LOG_FILE_NAME = "log";
    private static final long DEFAULT_LOG_FILE_MAX_SIZE = 0x100000L;
    private static final Map<Class<?>, ObjectFormatter<?>> BUILTIN_OBJECT_FORMATTERS;

    public static JsonFormatter createJsonFormatter() {
        return new DefaultJsonFormatter();
    }

    public static XmlFormatter createXmlFormatter() {
        return new DefaultXmlFormatter();
    }

    public static ThrowableFormatter createThrowableFormatter() {
        return new DefaultThrowableFormatter();
    }

    public static ThreadFormatter createThreadFormatter() {
        return new DefaultThreadFormatter();
    }

    public static StackTraceFormatter createStackTraceFormatter() {
        return new DefaultStackTraceFormatter();
    }

    public static BorderFormatter createBorderFormatter() {
        return new DefaultBorderFormatter();
    }

    public static Flattener createFlattener() {
        return new DefaultFlattener();
    }

    public static Printer createPrinter() {
        return Platform.get().defaultPrinter();
    }

    public static FileNameGenerator createFileNameGenerator() {
        return new ChangelessFileNameGenerator(DEFAULT_LOG_FILE_NAME);
    }

    public static BackupStrategy createBackupStrategy() {
        return new FileSizeBackupStrategy(0x100000L);
    }

    public static Map<Class<?>, ObjectFormatter<?>> builtinObjectFormatters() {
        return BUILTIN_OBJECT_FORMATTERS;
    }

    static {
        HashMap<Class, ObjectFormatter<Bundle>> objectFormatters = new HashMap<Class, ObjectFormatter<Bundle>>();
        objectFormatters.put(Bundle.class, new BundleFormatter());
        objectFormatters.put(Intent.class, new IntentFormatter());
        BUILTIN_OBJECT_FORMATTERS = Collections.unmodifiableMap(objectFormatters);
    }
}

