/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.Logger;
import com.elvishew.xlog.formatter.border.BorderFormatter;
import com.elvishew.xlog.formatter.message.json.JsonFormatter;
import com.elvishew.xlog.formatter.message.object.ObjectFormatter;
import com.elvishew.xlog.formatter.message.throwable.ThrowableFormatter;
import com.elvishew.xlog.formatter.message.xml.XmlFormatter;
import com.elvishew.xlog.formatter.stacktrace.StackTraceFormatter;
import com.elvishew.xlog.formatter.thread.ThreadFormatter;
import com.elvishew.xlog.interceptor.Interceptor;
import com.elvishew.xlog.internal.DefaultsFactory;
import com.elvishew.xlog.internal.Platform;
import com.elvishew.xlog.internal.util.StackTraceUtil;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.PrinterSet;

public class XLog {
    private static Logger sLogger;
    static LogConfiguration sLogConfiguration;
    static Printer sPrinter;
    static boolean sIsInitialized;

    private XLog() {
    }

    public static void init() {
        XLog.init(new LogConfiguration.Builder().build(), DefaultsFactory.createPrinter());
    }

    public static void init(int logLevel) {
        XLog.init(new LogConfiguration.Builder().logLevel(logLevel).build(), DefaultsFactory.createPrinter());
    }

    @Deprecated
    public static void init(int logLevel, LogConfiguration logConfiguration) {
        XLog.init(new LogConfiguration.Builder(logConfiguration).logLevel(logLevel).build());
    }

    public static void init(LogConfiguration logConfiguration) {
        XLog.init(logConfiguration, DefaultsFactory.createPrinter());
    }

    public static void init(Printer ... printers) {
        XLog.init(new LogConfiguration.Builder().build(), printers);
    }

    public static void init(int logLevel, Printer ... printers) {
        XLog.init(new LogConfiguration.Builder().logLevel(logLevel).build(), printers);
    }

    @Deprecated
    public static void init(int logLevel, LogConfiguration logConfiguration, Printer ... printers) {
        XLog.init(new LogConfiguration.Builder(logConfiguration).logLevel(logLevel).build(), printers);
    }

    public static void init(LogConfiguration logConfiguration, Printer ... printers) {
        if (sIsInitialized) {
            Platform.get().warn("XLog is already initialized, do not initialize again");
        }
        sIsInitialized = true;
        if (logConfiguration == null) {
            throw new IllegalArgumentException("Please specify a LogConfiguration");
        }
        sLogConfiguration = logConfiguration;
        sPrinter = new PrinterSet(printers);
        sLogger = new Logger(sLogConfiguration, sPrinter);
    }

    static void assertInitialization() {
        if (!sIsInitialized) {
            throw new IllegalStateException("Do you forget to initialize XLog?");
        }
    }

    public static Logger.Builder logLevel(int logLevel) {
        return new Logger.Builder().logLevel(logLevel);
    }

    public static Logger.Builder tag(String tag) {
        return new Logger.Builder().tag(tag);
    }

    public static Logger.Builder t() {
        return new Logger.Builder().t();
    }

    public static Logger.Builder nt() {
        return new Logger.Builder().nt();
    }

    public static Logger.Builder st(int depth) {
        return new Logger.Builder().st(depth);
    }

    public static Logger.Builder st(String stackTraceOrigin, int depth) {
        return new Logger.Builder().st(stackTraceOrigin, depth);
    }

    public static Logger.Builder nst() {
        return new Logger.Builder().nst();
    }

    public static Logger.Builder b() {
        return new Logger.Builder().b();
    }

    public static Logger.Builder nb() {
        return new Logger.Builder().nb();
    }

    public static Logger.Builder jsonFormatter(JsonFormatter jsonFormatter) {
        return new Logger.Builder().jsonFormatter(jsonFormatter);
    }

    public static Logger.Builder xmlFormatter(XmlFormatter xmlFormatter) {
        return new Logger.Builder().xmlFormatter(xmlFormatter);
    }

    public static Logger.Builder throwableFormatter(ThrowableFormatter throwableFormatter) {
        return new Logger.Builder().throwableFormatter(throwableFormatter);
    }

    public static Logger.Builder threadFormatter(ThreadFormatter threadFormatter) {
        return new Logger.Builder().threadFormatter(threadFormatter);
    }

    public static Logger.Builder stackTraceFormatter(StackTraceFormatter stackTraceFormatter) {
        return new Logger.Builder().stackTraceFormatter(stackTraceFormatter);
    }

    public static Logger.Builder borderFormatter(BorderFormatter borderFormatter) {
        return new Logger.Builder().borderFormatter(borderFormatter);
    }

    public static <T> Logger.Builder addObjectFormatter(Class<T> objectClass, ObjectFormatter<? super T> objectFormatter) {
        return new Logger.Builder().addObjectFormatter(objectClass, objectFormatter);
    }

    public static Logger.Builder addInterceptor(Interceptor interceptor) {
        return new Logger.Builder().addInterceptor(interceptor);
    }

    public static Logger.Builder printers(Printer ... printers) {
        return new Logger.Builder().printers(printers);
    }

    public static void v(Object object) {
        XLog.assertInitialization();
        sLogger.v(object);
    }

    public static void v(Object[] array) {
        XLog.assertInitialization();
        sLogger.v(array);
    }

    public static void v(String format, Object ... args) {
        XLog.assertInitialization();
        sLogger.v(format, args);
    }

    public static void v(String msg) {
        XLog.assertInitialization();
        sLogger.v(msg);
    }

    public static void v(String msg, Throwable tr) {
        XLog.assertInitialization();
        sLogger.v(msg, tr);
    }

    public static void d(Object object) {
        XLog.assertInitialization();
        sLogger.d(object);
    }

    public static void d(Object[] array) {
        XLog.assertInitialization();
        sLogger.d(array);
    }

    public static void d(String format, Object ... args) {
        XLog.assertInitialization();
        sLogger.d(format, args);
    }

    public static void d(String msg) {
        XLog.assertInitialization();
        sLogger.d(msg);
    }

    public static void d(String msg, Throwable tr) {
        XLog.assertInitialization();
        sLogger.d(msg, tr);
    }

    public static void i(Object object) {
        XLog.assertInitialization();
        sLogger.i(object);
    }

    public static void i(Object[] array) {
        XLog.assertInitialization();
        sLogger.i(array);
    }

    public static void i(String format, Object ... args) {
        XLog.assertInitialization();
        sLogger.i(format, args);
    }

    public static void i(String msg) {
        XLog.assertInitialization();
        sLogger.i(msg);
    }

    public static void i(String msg, Throwable tr) {
        XLog.assertInitialization();
        sLogger.i(msg, tr);
    }

    public static void w(Object object) {
        XLog.assertInitialization();
        sLogger.w(object);
    }

    public static void w(Object[] array) {
        XLog.assertInitialization();
        sLogger.w(array);
    }

    public static void w(String format, Object ... args) {
        XLog.assertInitialization();
        sLogger.w(format, args);
    }

    public static void w(String msg) {
        XLog.assertInitialization();
        sLogger.w(msg);
    }

    public static void w(String msg, Throwable tr) {
        XLog.assertInitialization();
        sLogger.w(msg, tr);
    }

    public static void e(Object object) {
        XLog.assertInitialization();
        sLogger.e(object);
    }

    public static void e(Object[] array) {
        XLog.assertInitialization();
        sLogger.e(array);
    }

    public static void e(String format, Object ... args) {
        XLog.assertInitialization();
        sLogger.e(format, args);
    }

    public static void e(String msg) {
        XLog.assertInitialization();
        sLogger.e(msg);
    }

    public static void e(String msg, Throwable tr) {
        XLog.assertInitialization();
        sLogger.e(msg, tr);
    }

    public static void log(int logLevel, Object object) {
        XLog.assertInitialization();
        sLogger.log(logLevel, object);
    }

    public static void log(int logLevel, Object[] array) {
        XLog.assertInitialization();
        sLogger.log(logLevel, array);
    }

    public static void log(int logLevel, String format, Object ... args) {
        XLog.assertInitialization();
        sLogger.log(logLevel, format, args);
    }

    public static void log(int logLevel, String msg) {
        XLog.assertInitialization();
        sLogger.log(logLevel, msg);
    }

    public static void log(int logLevel, String msg, Throwable tr) {
        XLog.assertInitialization();
        sLogger.log(logLevel, msg, tr);
    }

    public static void json(String json) {
        XLog.assertInitialization();
        sLogger.json(json);
    }

    public static void xml(String xml) {
        XLog.assertInitialization();
        sLogger.xml(xml);
    }

    public static class Log {
        public static void v(String tag, String msg) {
            XLog.tag(tag).build().v(msg);
        }

        public static void v(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().v(msg, tr);
        }

        public static void d(String tag, String msg) {
            XLog.tag(tag).build().d(msg);
        }

        public static void d(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().d(msg, tr);
        }

        public static void i(String tag, String msg) {
            XLog.tag(tag).build().i(msg);
        }

        public static void i(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().i(msg, tr);
        }

        public static void w(String tag, String msg) {
            XLog.tag(tag).build().w(msg);
        }

        public static void w(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().w(msg, tr);
        }

        public static void w(String tag, Throwable tr) {
            XLog.tag(tag).build().w("", tr);
        }

        public static void e(String tag, String msg) {
            XLog.tag(tag).build().e(msg);
        }

        public static void e(String tag, String msg, Throwable tr) {
            XLog.tag(tag).build().e(msg, tr);
        }

        public static void wtf(String tag, String msg) {
            Log.e(tag, msg);
        }

        public static void wtf(String tag, Throwable tr) {
            Log.wtf(tag, "", tr);
        }

        public static void wtf(String tag, String msg, Throwable tr) {
            Log.e(tag, msg, tr);
        }

        public static void println(int logLevel, String tag, String msg) {
            XLog.tag(tag).build().println(logLevel, msg);
        }

        public static boolean isLoggable(String tag, int level) {
            return sLogConfiguration.isLoggable(level);
        }

        public static String getStackTraceString(Throwable tr) {
            return StackTraceUtil.getStackTraceString(tr);
        }
    }
}

